/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerProperties;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerPropertySource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwsSecretsManagerPropertySources {
    private static Log LOG = LogFactory.getLog(AwsSecretsManagerPropertySources.class);
    private final AwsSecretsManagerProperties properties;

    public AwsSecretsManagerPropertySources(AwsSecretsManagerProperties properties) {
        this.properties = properties;
    }

    public List<String> getAutomaticContexts(List<String> profiles) {
        ArrayList<String> contexts = new ArrayList<String>();
        String prefix = this.properties.getPrefix();
        String defaultContext = this.getContext(prefix, this.properties.getDefaultContext());
        contexts.add(defaultContext);
        this.addProfiles(contexts, defaultContext, profiles);
        String appName = this.properties.getName();
        String appContext = prefix + "/" + appName;
        contexts.add(appContext);
        this.addProfiles(contexts, appContext, profiles);
        return contexts;
    }

    private String getContext(String prefix, String context) {
        if (prefix != null) {
            return prefix + "/" + context;
        }
        return context;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile);
        }
    }

    public AwsSecretsManagerPropertySource createPropertySource(String context, boolean optional, AWSSecretsManager client) {
        LOG.info((Object)("Loading secrets from AWS Secret Manager secret with name: " + context + ", optional: " + optional));
        try {
            AwsSecretsManagerPropertySource propertySource = new AwsSecretsManagerPropertySource(context, client);
            propertySource.init();
            return propertySource;
        }
        catch (Exception e) {
            if (!optional) {
                throw new AwsSecretsManagerPropertySourceNotFoundException(e);
            }
            LOG.warn((Object)("Unable to load AWS secret from " + context + ". " + e.getMessage()));
            return null;
        }
    }

    static class AwsSecretsManagerPropertySourceNotFoundException
    extends RuntimeException {
        AwsSecretsManagerPropertySourceNotFoundException(Exception source) {
            super(source);
        }
    }
}

