/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.DiskBufferingS3OutputStream;
import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStream;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.s3.S3Client;

public class DiskBufferingS3OutputStreamProvider
implements S3OutputStreamProvider {
    private final S3Client s3Client;
    @Nullable
    private final S3ObjectContentTypeResolver contentTypeResolver;

    public DiskBufferingS3OutputStreamProvider(S3Client s3Client, @Nullable S3ObjectContentTypeResolver contentTypeResolver) {
        Assert.notNull((Object)s3Client, (String)"s3Client is required");
        this.s3Client = s3Client;
        this.contentTypeResolver = contentTypeResolver;
    }

    @Override
    public S3OutputStream create(String bucket, String key, @Nullable ObjectMetadata metadata) throws IOException {
        Assert.notNull((Object)bucket, (String)"bucket is required");
        Assert.notNull((Object)key, (String)"key is required");
        return new DiskBufferingS3OutputStream(new Location(bucket, key, null), this.s3Client, metadata, this.contentTypeResolver);
    }
}

