/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3Exception;
import io.awspring.cloud.s3.S3ObjectConverter;
import io.awspring.cloud.s3.S3Operations;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.S3Resource;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3Template
implements S3Operations {
    private final S3Client s3Client;
    private final S3OutputStreamProvider s3OutputStreamProvider;
    private final S3ObjectConverter s3ObjectConverter;

    public S3Template(S3Client s3Client, S3OutputStreamProvider s3OutputStreamProvider, S3ObjectConverter s3ObjectConverter) {
        Assert.notNull((Object)s3Client, (String)"s3Client is required");
        Assert.notNull((Object)s3OutputStreamProvider, (String)"s3OutputStreamProvider is required");
        Assert.notNull((Object)s3ObjectConverter, (String)"s3ObjectConverter is required");
        this.s3Client = s3Client;
        this.s3OutputStreamProvider = s3OutputStreamProvider;
        this.s3ObjectConverter = s3ObjectConverter;
    }

    @Override
    public String createBucket(String bucketName) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        return this.s3Client.createBucket(request -> request.bucket(bucketName)).location();
    }

    @Override
    public void deleteBucket(String bucketName) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        this.s3Client.deleteBucket(request -> request.bucket(bucketName));
    }

    @Override
    public void deleteObject(String bucketName, String key) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        this.s3Client.deleteObject(request -> request.bucket(bucketName).key(key));
    }

    @Override
    public void deleteObject(String s3Url) {
        Assert.notNull((Object)s3Url, (String)"s3Url is required");
        Location location = Location.of(s3Url);
        this.deleteObject(location.getBucket(), location.getObject());
    }

    @Override
    public S3Resource store(String bucketName, String key, Object object) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull((Object)object, (String)"object is required");
        PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(bucketName).key(key).contentType(this.s3ObjectConverter.contentType());
        this.s3Client.putObject((PutObjectRequest)requestBuilder.build(), this.s3ObjectConverter.write(object));
        return new S3Resource(bucketName, key, this.s3Client, this.s3OutputStreamProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T read(String bucketName, String key, Class<T> clazz) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull(clazz, (String)"clazz is required");
        try (ResponseInputStream is = this.s3Client.getObject(r -> r.bucket(bucketName).key(key));){
            T t = this.s3ObjectConverter.read((InputStream)is, clazz);
            return t;
        }
        catch (Exception e) {
            throw new S3Exception(String.format("Failed to read object with a key '%s' from bucket '%s'", key, bucketName), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public S3Resource upload(String bucketName, String key, InputStream inputStream, @Nullable ObjectMetadata objectMetadata) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull((Object)inputStream, (String)"inputStream is required");
        S3Resource s3Resource = new S3Resource(bucketName, key, this.s3Client, this.s3OutputStreamProvider);
        if (objectMetadata != null) {
            s3Resource.setObjectMetadata(objectMetadata);
        }
        try (OutputStream os = s3Resource.getOutputStream();){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)os);
            S3Resource s3Resource2 = s3Resource;
            return s3Resource2;
        }
        catch (Exception e) {
            throw new S3Exception(String.format("Failed to upload object with a key '%s' to bucket '%s'", key, bucketName), e);
        }
    }

    @Override
    public S3Resource download(String bucketName, String key) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        return new S3Resource(bucketName, key, this.s3Client, this.s3OutputStreamProvider);
    }
}

