/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.endpoint;

import com.amazonaws.services.sns.message.SnsMessageManager;
import com.fasterxml.jackson.databind.JsonNode;
import io.awspring.cloud.messaging.config.annotation.NotificationMessage;
import io.awspring.cloud.messaging.endpoint.AbstractNotificationMessageHandlerMethodArgumentResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.StringUtils;

public class NotificationMessageHandlerMethodArgumentResolver
extends AbstractNotificationMessageHandlerMethodArgumentResolver {
    private final List<HttpMessageConverter<?>> messageConverter;
    private final SnsMessageManager snsMessageManager;

    public NotificationMessageHandlerMethodArgumentResolver(SnsMessageManager snsMessageManager) {
        this(Arrays.asList(new MappingJackson2HttpMessageConverter(), new StringHttpMessageConverter()), snsMessageManager);
    }

    public NotificationMessageHandlerMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverter, SnsMessageManager snsMessageManager) {
        this.snsMessageManager = snsMessageManager;
        this.messageConverter = messageConverter;
    }

    private static MediaType getMediaType(JsonNode content) {
        String contentType;
        JsonNode contentTypeNode = content.findPath("MessageAttributes").findPath("contentType");
        if (contentTypeNode.isObject() && StringUtils.hasText((String)(contentType = contentTypeNode.findPath("Value").asText()))) {
            return MediaType.parseMediaType((String)contentType);
        }
        return MediaType.TEXT_PLAIN;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(NotificationMessage.class);
    }

    @Override
    protected Object doResolveArgumentFromNotificationMessage(JsonNode content, HttpInputMessage request, Class<?> parameterType) {
        if (!"Notification".equals(content.get("Type").asText())) {
            throw new IllegalArgumentException("@NotificationMessage annotated parameters are only allowed for method that receive a notification message.");
        }
        MediaType mediaType = NotificationMessageHandlerMethodArgumentResolver.getMediaType(content);
        String messageContent = content.findPath("Message").asText();
        if (this.snsMessageManager != null && content.has("SignatureVersion")) {
            this.verifySignature(content.toString());
        }
        for (HttpMessageConverter<?> converter : this.messageConverter) {
            if (!converter.canRead(parameterType, mediaType)) continue;
            try {
                return converter.read(parameterType, (HttpInputMessage)new ByteArrayHttpInputMessage(messageContent, mediaType, request));
            }
            catch (Exception e) {
                throw new HttpMessageNotReadableException("Error converting notification message with payload:" + messageContent, (Throwable)e);
            }
        }
        throw new HttpMessageNotReadableException("Error converting notification message with payload:" + messageContent);
    }

    private void verifySignature(String payload) {
        try (ByteArrayInputStream messageStream = new ByteArrayInputStream(payload.getBytes());){
            this.snsMessageManager.parseMessage((InputStream)messageStream);
        }
        catch (IOException e) {
            throw new MessageConversionException("Issue while verifying signature of Payload: '" + payload + "'", (Throwable)e);
        }
    }

    private static final class ByteArrayHttpInputMessage
    implements HttpInputMessage {
        private final String content;
        private final MediaType mediaType;
        private final HttpInputMessage request;

        private ByteArrayHttpInputMessage(String content, MediaType mediaType, HttpInputMessage request) {
            this.content = content;
            this.mediaType = mediaType;
            this.request = request;
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes(this.getCharset()));
        }

        private Charset getCharset() {
            return this.mediaType.getCharset() != null ? this.mediaType.getCharset() : Charset.forName(StandardCharsets.UTF_8.name());
        }

        public HttpHeaders getHeaders() {
            return this.request.getHeaders();
        }
    }
}

