/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.core;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;

public class TopicMessageChannel
extends AbstractMessageChannel {
    public static final String NOTIFICATION_SUBJECT_HEADER = "NOTIFICATION_SUBJECT_HEADER";
    public static final String MESSAGE_GROUP_ID_HEADER = "message-group-id";
    public static final String MESSAGE_DEDUPLICATION_ID_HEADER = "message-deduplication-id";
    private final JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
    private final AmazonSNS amazonSns;
    private final String topicArn;

    public TopicMessageChannel(AmazonSNS amazonSns, String topicArn) {
        this.amazonSns = amazonSns;
        this.topicArn = topicArn;
    }

    private static String findNotificationSubject(Message<?> message) {
        return message.getHeaders().containsKey((Object)NOTIFICATION_SUBJECT_HEADER) ? message.getHeaders().get((Object)NOTIFICATION_SUBJECT_HEADER).toString() : null;
    }

    protected boolean sendInternal(Message<?> message, long timeout) {
        PublishRequest publishRequest = new PublishRequest(this.topicArn, message.getPayload().toString(), TopicMessageChannel.findNotificationSubject(message));
        Map<String, MessageAttributeValue> messageAttributes = this.getMessageAttributes(message);
        if (!messageAttributes.isEmpty()) {
            publishRequest.withMessageAttributes(messageAttributes);
        }
        if (message.getHeaders().containsKey((Object)MESSAGE_GROUP_ID_HEADER)) {
            publishRequest.withMessageGroupId((String)message.getHeaders().get((Object)MESSAGE_GROUP_ID_HEADER, String.class));
        }
        if (message.getHeaders().containsKey((Object)MESSAGE_DEDUPLICATION_ID_HEADER)) {
            publishRequest.withMessageDeduplicationId((String)message.getHeaders().get((Object)MESSAGE_DEDUPLICATION_ID_HEADER, String.class));
        }
        this.amazonSns.publish(publishRequest);
        return true;
    }

    private Map<String, MessageAttributeValue> getMessageAttributes(Message<?> message) {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
        for (Map.Entry messageHeader : message.getHeaders().entrySet()) {
            String messageHeaderName = (String)messageHeader.getKey();
            Object messageHeaderValue = messageHeader.getValue();
            if (this.isSkipHeader(messageHeaderName)) continue;
            if ("contentType".equals(messageHeaderName) && messageHeaderValue != null) {
                messageAttributes.put(messageHeaderName, this.getContentTypeMessageAttribute(messageHeaderValue));
                continue;
            }
            if ("id".equals(messageHeaderName) && messageHeaderValue != null) {
                messageAttributes.put(messageHeaderName, this.getStringMessageAttribute(messageHeaderValue.toString()));
                continue;
            }
            if (messageHeaderValue instanceof String) {
                messageAttributes.put(messageHeaderName, this.getStringMessageAttribute((String)messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof Number) {
                messageAttributes.put(messageHeaderName, this.getNumberMessageAttribute(messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof ByteBuffer) {
                messageAttributes.put(messageHeaderName, this.getBinaryMessageAttribute((ByteBuffer)messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof List) {
                messageAttributes.put(messageHeaderName, this.getStringArrayMessageAttribute((List)messageHeaderValue));
                continue;
            }
            this.logger.warn((Object)String.format("Message header with name '%s' and type '%s' cannot be sent as message attribute because it is not supported by SNS.", messageHeaderName, messageHeaderValue != null ? messageHeaderValue.getClass().getName() : ""));
        }
        return messageAttributes;
    }

    private boolean isSkipHeader(String headerName) {
        return MESSAGE_GROUP_ID_HEADER.equals(headerName) || MESSAGE_DEDUPLICATION_ID_HEADER.equals(headerName);
    }

    private MessageAttributeValue getStringArrayMessageAttribute(List<Object> messageHeaderValue) {
        List stringValues = messageHeaderValue.stream().map(item -> "\"" + String.valueOf(this.jsonStringEncoder.quoteAsString(item.toString())) + "\"").collect(Collectors.toList());
        String stringValue = "[" + String.join((CharSequence)", ", stringValues) + "]";
        return new MessageAttributeValue().withDataType("String.Array").withStringValue(stringValue);
    }

    private MessageAttributeValue getBinaryMessageAttribute(ByteBuffer messageHeaderValue) {
        return new MessageAttributeValue().withDataType("Binary").withBinaryValue(messageHeaderValue);
    }

    private MessageAttributeValue getContentTypeMessageAttribute(Object messageHeaderValue) {
        if (messageHeaderValue instanceof MimeType) {
            return new MessageAttributeValue().withDataType("String").withStringValue(messageHeaderValue.toString());
        }
        if (messageHeaderValue instanceof String) {
            return new MessageAttributeValue().withDataType("String").withStringValue((String)messageHeaderValue);
        }
        return null;
    }

    private MessageAttributeValue getStringMessageAttribute(String messageHeaderValue) {
        return new MessageAttributeValue().withDataType("String").withStringValue(messageHeaderValue);
    }

    private MessageAttributeValue getNumberMessageAttribute(Object messageHeaderValue) {
        Assert.isTrue((boolean)NumberUtils.STANDARD_NUMBER_TYPES.contains(messageHeaderValue.getClass()), (String)"Only standard number types are accepted as message header.");
        return new MessageAttributeValue().withDataType("Number." + messageHeaderValue.getClass().getName()).withStringValue(messageHeaderValue.toString());
    }
}

