/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.endpoint;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractNotificationMessageHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String NOTIFICATION_REQUEST_ATTRIBUTE_NAME = "NOTIFICATION_REQUEST";
    private final MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Assert.notNull((Object)parameter, (String)"Parameter must not be null");
        if (webRequest.getAttribute(NOTIFICATION_REQUEST_ATTRIBUTE_NAME, 0) == null) {
            webRequest.setAttribute(NOTIFICATION_REQUEST_ATTRIBUTE_NAME, this.messageConverter.read(JsonNode.class, this.createInputMessage(webRequest)), 0);
        }
        JsonNode content = (JsonNode)webRequest.getAttribute(NOTIFICATION_REQUEST_ATTRIBUTE_NAME, 0);
        return this.doResolveArgumentFromNotificationMessage(content, this.createInputMessage(webRequest), parameter.getParameterType());
    }

    protected abstract Object doResolveArgumentFromNotificationMessage(JsonNode var1, HttpInputMessage var2, Class<?> var3);

    private HttpInputMessage createInputMessage(NativeWebRequest webRequest) throws IOException {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        return new ServletServerHttpRequest(servletRequest);
    }
}

