/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.dynamodb;

import io.awspring.cloud.dynamodb.DynamoDbLockRepository;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.integration.support.locks.DistributedLock;
import org.springframework.integration.support.locks.ExpirableLockRegistry;
import org.springframework.integration.support.locks.RenewableLockRegistry;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;

public class DynamoDbLockRegistry
implements ExpirableLockRegistry<DistributedLock>,
RenewableLockRegistry<DistributedLock> {
    private final Map<String, DynamoDbLock> locks = new ConcurrentHashMap<String, DynamoDbLock>();
    private final DynamoDbLockRepository dynamoDbLockRepository;
    private Duration idleBetweenTries = Duration.ofMillis(100L);
    private Duration ttl = Duration.ofSeconds(60L);

    public DynamoDbLockRegistry(DynamoDbLockRepository dynamoDbLockRepository) {
        this.dynamoDbLockRepository = dynamoDbLockRepository;
    }

    public void setIdleBetweenTries(Duration idleBetweenTries) {
        this.idleBetweenTries = idleBetweenTries;
    }

    public void setTimeToLive(Duration ttl) {
        this.ttl = ttl;
    }

    public DistributedLock obtain(Object lockKey) {
        Assert.isInstanceOf(String.class, (Object)lockKey, (String)"'lockKey' must of String type");
        return this.locks.computeIfAbsent((String)lockKey, x$0 -> new DynamoDbLock((String)x$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireUnusedOlderThan(long age) {
        long now = System.currentTimeMillis();
        Map<String, DynamoDbLock> map = this.locks;
        synchronized (map) {
            this.locks.entrySet().removeIf(entry -> {
                DynamoDbLock lock = (DynamoDbLock)entry.getValue();
                return now - lock.lastUsed > age && !lock.isAcquiredInThisProcess();
            });
        }
    }

    public void renewLock(Object lockKey) {
        this.renewLock(lockKey, this.ttl);
    }

    public void renewLock(Object lockKey, Duration ttl) {
        String lockId = (String)lockKey;
        DynamoDbLock dynamoDbLock = this.locks.get(lockId);
        if (dynamoDbLock == null) {
            throw new IllegalStateException("Could not find mutex at " + lockId);
        }
        if (!dynamoDbLock.renew(ttl)) {
            throw new IllegalStateException("Could not renew mutex at " + lockId);
        }
    }

    public String toString() {
        return "DynamoDbLockRegistry{tableName='" + this.dynamoDbLockRepository.getTableName() + "', owner='" + this.dynamoDbLockRepository.getOwner() + "}";
    }

    private final class DynamoDbLock
    implements DistributedLock {
        private final ReentrantLock delegate = new ReentrantLock();
        private final String key;
        private volatile long lastUsed = System.currentTimeMillis();

        private DynamoDbLock(String key) {
            this.key = key;
        }

        private void rethrowAsLockException(Exception e) {
            throw new CannotAcquireLockException("Failed to lock at " + this.key, (Throwable)e);
        }

        public void lock() {
            this.lock(DynamoDbLockRegistry.this.ttl);
        }

        public void lock(Duration ttl) {
            this.delegate.lock();
            while (true) {
                try {
                    while (!this.doLock(ttl)) {
                        this.sleepBetweenRetries();
                    }
                }
                catch (TransactionConflictException transactionConflictException) {
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception ex) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(ex);
                    continue;
                }
                break;
            }
        }

        public void lockInterruptibly() throws InterruptedException {
            this.delegate.lockInterruptibly();
            while (true) {
                try {
                    while (!this.doLock(DynamoDbLockRegistry.this.ttl)) {
                        this.sleepBetweenRetries();
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                catch (TransactionConflictException transactionConflictException) {
                    continue;
                }
                catch (InterruptedException ie) {
                    this.delegate.unlock();
                    Thread.currentThread().interrupt();
                    throw ie;
                }
                catch (Exception e) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        public boolean tryLock() {
            try {
                return this.tryLock(0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.tryLock(Duration.of(time, unit.toChronoUnit()), DynamoDbLockRegistry.this.ttl);
        }

        public boolean tryLock(Duration waitTime, Duration ttl) throws InterruptedException {
            long now = System.currentTimeMillis();
            if (!this.delegate.tryLock(waitTime.toMillis(), TimeUnit.MILLISECONDS)) {
                return false;
            }
            long expire = now + waitTime.toMillis();
            while (true) {
                try {
                    boolean acquired;
                    while (!(acquired = this.doLock(ttl)) && System.currentTimeMillis() < expire) {
                        this.sleepBetweenRetries();
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                    if (!acquired) {
                        this.delegate.unlock();
                    }
                    return acquired;
                }
                catch (TransactionConflictException transactionConflictException) {
                    continue;
                }
                catch (Exception ex) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(ex);
                    continue;
                }
                break;
            }
        }

        private boolean doLock(Duration ttl) throws InterruptedException {
            boolean acquired = DynamoDbLockRegistry.this.dynamoDbLockRepository.acquire(this.key, ttl);
            if (acquired) {
                this.lastUsed = System.currentTimeMillis();
            }
            return acquired;
        }

        public void unlock() {
            if (!this.delegate.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException("The current thread doesn't own mutex at '" + this.key + "'");
            }
            if (this.delegate.getHoldCount() > 1) {
                this.delegate.unlock();
                return;
            }
            while (true) {
                try {
                    DynamoDbLockRegistry.this.dynamoDbLockRepository.delete(this.key);
                    return;
                }
                catch (TransactionConflictException ex) {
                    try {
                        this.sleepBetweenRetries();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                catch (Exception ex) {
                    throw new DataAccessResourceFailureException("Failed to release mutex at " + this.key, (Throwable)ex);
                }
                break;
            }
            finally {
                this.delegate.unlock();
            }
        }

        /*
         * Loose catch block
         */
        public boolean renew(Duration ttl) {
            if (!this.delegate.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException("The current thread doesn't own mutex at " + this.key);
            }
            while (true) {
                try {
                    boolean renewed = DynamoDbLockRegistry.this.dynamoDbLockRepository.renew(this.key, ttl);
                    if (renewed) {
                        this.lastUsed = System.currentTimeMillis();
                    }
                    return renewed;
                }
                catch (TransactionConflictException ex) {
                    try {
                        this.sleepBetweenRetries();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Failed to renew mutex at " + this.key, (Throwable)ex);
            }
        }

        public boolean isAcquiredInThisProcess() {
            return DynamoDbLockRegistry.this.dynamoDbLockRepository.isAcquired(this.key);
        }

        private void sleepBetweenRetries() throws InterruptedException {
            Thread.sleep(DynamoDbLockRegistry.this.idleBetweenTries.toMillis());
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException("DynamoDb locks don't support conditions.");
        }

        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd@HH:mm:ss.SSS");
            return "DynamoDbLock [lockKey=" + this.key + ",lockedAt=" + dateFormat.format(new Date(this.lastUsed)) + "]";
        }
    }
}

