/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.context.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.ec2.AmazonEC2;
import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.context.config.annotation.ContextDefaultConfigurationRegistrar;
import io.awspring.cloud.context.config.annotation.EnableStackConfiguration;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.env.stack.config.AutoDetectingStackNameProvider;
import io.awspring.cloud.core.env.stack.config.StackNameProvider;
import io.awspring.cloud.core.env.stack.config.StackResourceRegistryFactoryBean;
import io.awspring.cloud.core.env.stack.config.StaticStackNameProvider;
import io.awspring.cloud.core.region.RegionProvider;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextDefaultConfigurationRegistrar.class})
@Deprecated
public class ContextStackConfiguration
implements ImportAware {
    private AnnotationAttributes annotationAttributes;
    private final RegionProvider regionProvider;
    private final AWSCredentialsProvider credentialsProvider;
    private final AmazonEC2 amazonEc2;

    public ContextStackConfiguration(ObjectProvider<RegionProvider> regionProvider, ObjectProvider<AWSCredentialsProvider> credentialsProvider, ObjectProvider<AmazonEC2> amazonEc2) {
        this.regionProvider = (RegionProvider)regionProvider.getIfAvailable();
        this.credentialsProvider = (AWSCredentialsProvider)credentialsProvider.getIfAvailable();
        this.amazonEc2 = (AmazonEC2)amazonEc2.getIfAvailable();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.annotationAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableStackConfiguration.class.getName(), false));
        Assert.notNull((Object)this.annotationAttributes, (String)("@EnableStackConfiguration is not present on importing class " + importMetadata.getClassName()));
    }

    @Bean
    public StackResourceRegistryFactoryBean stackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormation) {
        if (StringUtils.hasText((String)this.annotationAttributes.getString("stackName"))) {
            return new StackResourceRegistryFactoryBean(amazonCloudFormation, (StackNameProvider)new StaticStackNameProvider(this.annotationAttributes.getString("stackName")));
        }
        return new StackResourceRegistryFactoryBean(amazonCloudFormation, (StackNameProvider)new AutoDetectingStackNameProvider(amazonCloudFormation, this.amazonEc2));
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonCloudFormation.class)
    public AmazonWebserviceClientFactoryBean<AmazonCloudFormationClient> amazonCloudFormation() {
        return new AmazonWebserviceClientFactoryBean(AmazonCloudFormationClient.class, this.credentialsProvider, this.regionProvider);
    }
}

