/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.autoconfigure.AwsSyncClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.autoconfigure.s3.S3AesProvider;
import io.awspring.cloud.autoconfigure.s3.S3ClientCustomizer;
import io.awspring.cloud.autoconfigure.s3.S3EncryptionClientCustomizer;
import io.awspring.cloud.autoconfigure.s3.S3EncryptionConditional;
import io.awspring.cloud.autoconfigure.s3.S3RsaProvider;
import io.awspring.cloud.autoconfigure.s3.properties.S3EncryptionProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3Properties;
import io.awspring.cloud.s3.InMemoryBufferingS3OutputStreamProvider;
import io.awspring.cloud.s3.Jackson2JsonS3ObjectConverter;
import io.awspring.cloud.s3.LegacyJackson2JsonS3ObjectConverter;
import io.awspring.cloud.s3.PropertiesS3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3ObjectConverter;
import io.awspring.cloud.s3.S3Operations;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.S3ProtocolResolver;
import io.awspring.cloud.s3.S3Template;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.s3accessgrants.plugin.S3AccessGrantsPlugin;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.encryption.s3.S3EncryptionClient;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
@ConditionalOnClass(value={S3Client.class, S3OutputStreamProvider.class})
@EnableConfigurationProperties(value={S3Properties.class, AwsProperties.class})
@Import(value={S3ProtocolResolver.class})
@ConditionalOnProperty(name={"spring.cloud.aws.s3.enabled"}, havingValue="true", matchIfMissing=true)
public class S3AutoConfiguration {
    private final S3Properties properties;

    public S3AutoConfiguration(S3Properties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    S3ClientBuilder s3ClientBuilder(AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsConnectionDetails> connectionDetails, ObjectProvider<S3ClientCustomizer> s3ClientCustomizers, ObjectProvider<AwsSyncClientCustomizer> awsSyncClientCustomizers) {
        S3ClientBuilder builder = awsClientBuilderConfigurer.configureSyncClient(S3Client.builder(), this.properties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), s3ClientCustomizers.orderedStream(), awsSyncClientCustomizers.orderedStream());
        if (ClassUtils.isPresent((String)"software.amazon.awssdk.s3accessgrants.plugin.S3AccessGrantsPlugin", null)) {
            S3AccessGrantsPlugin s3AccessGrantsPlugin = (S3AccessGrantsPlugin)S3AccessGrantsPlugin.builder().enableFallback(Boolean.valueOf(this.properties.getPlugin().getEnableFallback())).build();
            builder.addPlugin((SdkPlugin)s3AccessGrantsPlugin);
        }
        Optional.ofNullable(this.properties.getCrossRegionEnabled()).ifPresent(arg_0 -> ((S3ClientBuilder)builder).crossRegionAccessEnabled(arg_0));
        builder.serviceConfiguration(this.properties.toS3Configuration());
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean(value={S3Operations.class})
    @ConditionalOnBean(value={S3ObjectConverter.class})
    S3Template s3Template(S3Client s3Client, S3OutputStreamProvider s3OutputStreamProvider, S3ObjectConverter s3ObjectConverter, S3Presigner s3Presigner) {
        return new S3Template(s3Client, s3OutputStreamProvider, s3ObjectConverter, s3Presigner);
    }

    @Bean
    @ConditionalOnMissingBean
    S3Presigner s3Presigner(S3Properties properties, AwsProperties awsProperties, AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, ObjectProvider<AwsConnectionDetails> connectionDetails) {
        S3Presigner.Builder builder = S3Presigner.builder().serviceConfiguration(properties.toS3Configuration()).credentialsProvider(credentialsProvider).region(AwsClientBuilderConfigurer.resolveRegion(properties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), regionProvider));
        if (properties.getEndpoint() != null) {
            builder.endpointOverride(properties.getEndpoint());
        } else if (awsProperties.getEndpoint() != null) {
            builder.endpointOverride(awsProperties.getEndpoint());
        }
        connectionDetails.ifAvailable(it -> {
            if (it.getEndpoint() != null) {
                builder.endpointOverride(it.getEndpoint());
            }
        });
        Optional.ofNullable(awsProperties.getFipsEnabled()).ifPresent(arg_0 -> ((S3Presigner.Builder)builder).fipsEnabled(arg_0));
        Optional.ofNullable(awsProperties.getDualstackEnabled()).ifPresent(arg_0 -> ((S3Presigner.Builder)builder).dualstackEnabled(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    S3Client s3Client(S3ClientBuilder s3ClientBuilder) {
        return (S3Client)s3ClientBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    S3OutputStreamProvider inMemoryBufferingS3StreamProvider(S3Client s3Client, Optional<S3ObjectContentTypeResolver> contentTypeResolver) {
        return new InMemoryBufferingS3OutputStreamProvider(s3Client, contentTypeResolver.orElseGet(PropertiesS3ObjectContentTypeResolver::new));
    }

    @Configuration
    @ConditionalOnClass(name={"tools.jackson.databind.json.JsonMapper"})
    static class Jackson2JsonS3ObjectConverterConfiguration {
        Jackson2JsonS3ObjectConverterConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        S3ObjectConverter s3ObjectConverter(Optional<JsonMapper> jsonMapper) {
            return new Jackson2JsonS3ObjectConverter(jsonMapper.orElseGet(JsonMapper::new));
        }
    }

    @Configuration
    @AutoConfigureAfter(value={Jackson2JsonS3ObjectConverterConfiguration.class})
    @ConditionalOnClass(name={"com.fasterxml.jackson.databind.ObjectMapper"})
    static class LegacyJackson2JsonS3ObjectConverterConfiguration {
        LegacyJackson2JsonS3ObjectConverterConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        S3ObjectConverter s3ObjectConverter(Optional<ObjectMapper> objectMapper) {
            return new LegacyJackson2JsonS3ObjectConverter(objectMapper.orElseGet(ObjectMapper::new));
        }
    }

    @Conditional(value={S3EncryptionConditional.class})
    @ConditionalOnClass(name={"software.amazon.encryption.s3.S3EncryptionClient"})
    @Configuration
    public static class S3EncryptionConfiguration {
        private static void configureEncryptionProperties(S3Properties properties, ObjectProvider<S3RsaProvider> rsaProvider, ObjectProvider<S3AesProvider> aesProvider, S3EncryptionClient.Builder builder) {
            PropertyMapper propertyMapper = PropertyMapper.get();
            S3EncryptionProperties encryptionProperties = properties.getEncryption();
            propertyMapper.from(encryptionProperties::isEnableDelayedAuthenticationMode).to(arg_0 -> ((S3EncryptionClient.Builder)builder).enableDelayedAuthenticationMode(arg_0));
            propertyMapper.from(encryptionProperties::isEnableLegacyUnauthenticatedModes).to(arg_0 -> ((S3EncryptionClient.Builder)builder).enableLegacyUnauthenticatedModes(arg_0));
            propertyMapper.from(encryptionProperties::isEnableMultipartPutObject).to(arg_0 -> ((S3EncryptionClient.Builder)builder).enableMultipartPutObject(arg_0));
            if (!StringUtils.hasText((String)properties.getEncryption().getKeyId())) {
                if (aesProvider.getIfAvailable() != null) {
                    builder.aesKey(((S3AesProvider)aesProvider.getObject()).generateSecretKey());
                } else {
                    builder.rsaKeyPair(((S3RsaProvider)rsaProvider.getObject()).generateKeyPair());
                }
            } else {
                propertyMapper.from(encryptionProperties::getKeyId).to(arg_0 -> ((S3EncryptionClient.Builder)builder).kmsKeyId(arg_0));
            }
        }

        @Bean
        @ConditionalOnMissingBean
        S3Client s3EncryptionClient(S3EncryptionClient.Builder s3EncryptionBuilder, S3ClientBuilder s3ClientBuilder) {
            s3EncryptionBuilder.wrappedClient((S3Client)s3ClientBuilder.build());
            return s3EncryptionBuilder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        S3EncryptionClient.Builder s3EncrpytionClientBuilder(S3Properties properties, AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsConnectionDetails> connectionDetails, ObjectProvider<S3EncryptionClientCustomizer> s3ClientCustomizers, ObjectProvider<AwsSyncClientCustomizer> awsSyncClientCustomizers, ObjectProvider<S3RsaProvider> rsaProvider, ObjectProvider<S3AesProvider> aesProvider) {
            S3EncryptionClient.Builder builder = awsClientBuilderConfigurer.configureSyncClient(S3EncryptionClient.builderV4(), properties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), s3ClientCustomizers.orderedStream(), awsSyncClientCustomizers.orderedStream());
            Optional.ofNullable(properties.getCrossRegionEnabled()).ifPresent(arg_0 -> ((S3EncryptionClient.Builder)builder).crossRegionAccessEnabled(arg_0));
            builder.serviceConfiguration(properties.toS3Configuration());
            S3EncryptionConfiguration.configureEncryptionProperties(properties, rsaProvider, aesProvider, builder);
            return builder;
        }
    }
}

