/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.s3;

import io.awspring.cloud.autoconfigure.config.s3.AwsS3PropertySourceNotFoundException;
import io.awspring.cloud.s3.config.S3PropertySource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.s3.S3Client;

public class S3PropertySources {
    private static Log LOG = LogFactory.getLog(S3PropertySources.class);

    @Nullable
    public S3PropertySource createPropertySource(String context, boolean optional, S3Client client) {
        Assert.notNull((Object)context, (String)"context is required");
        Assert.notNull((Object)client, (String)"S3Client is required");
        LOG.info((Object)("Loading properties from AWS S3 object: " + context + ", optional: " + optional));
        try {
            S3PropertySource propertySource = new S3PropertySource(context, client);
            propertySource.init();
            return propertySource;
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to load AWS S3 object from " + context + ". " + e.getMessage()));
            if (!optional) {
                throw new AwsS3PropertySourceNotFoundException(e);
            }
            return null;
        }
    }
}

