/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.imds;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.imds.Ec2MetadataClient;
import software.amazon.awssdk.imds.Ec2MetadataResponse;

public class ImdsUtils {
    private static Logger logger = LoggerFactory.getLogger(ImdsUtils.class);
    private final Ec2MetadataClient client;
    private Boolean isCloudEnvironment;
    private final String prefix = "/latest/meta-data/";
    private final String[] keys = new String[]{"ami-id", "ami-launch-index", "ami-manifest-path", "hostname", "instance-action", "instance-id", "instance-life-cycle", "instance-type", "local-hostname", "local-ipv4", "mac", "profile", "public-hostname", "public-ipv4", "reservation-id", "security-groups", "ipv6", "kernel-id", "iam/info", "product-codes", "ramdisk-id", "reservation-id", "services/domain", "services/partition", "tags/instance", "autoscaling/target-lifecycle-state", "placement/availability-zone", "placement/availability-zone-id", "placement/group-name", "placement/host-id", "placement/partition-number", "placement/region"};

    public ImdsUtils(Ec2MetadataClient client) {
        this.client = client;
    }

    public boolean isRunningOnCloudEnvironment() {
        if (this.isCloudEnvironment == null) {
            this.isCloudEnvironment = false;
            try {
                Ec2MetadataResponse response = this.client.get("/latest/meta-data/ami-id");
                this.isCloudEnvironment = response.asString() != null && response.asString().length() > 0;
            }
            catch (SdkClientException e) {
                if (e.getMessage().contains("retries")) {
                } else {
                    logger.debug("Error occurred when accessing instance metadata.", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("Error occurred when accessing instance metadata.", (Throwable)e);
            }
            finally {
                if (this.isCloudEnvironment.booleanValue()) {
                    logger.info("EC2 Instance MetaData detected, application is running within an EC2 instance.");
                } else {
                    logger.info("EC2 Instance MetaData not detected, application is NOT running within an EC2 instance.");
                }
            }
        }
        return this.isCloudEnvironment;
    }

    public Map<String, String> getEc2InstanceMetadata() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (!this.isRunningOnCloudEnvironment()) {
            return properties;
        }
        Arrays.stream(this.keys).forEach(t -> this.mapPut((Map<String, String>)properties, (String)t));
        return properties;
    }

    private void mapPut(Map<String, String> map, String key) {
        try {
            Ec2MetadataResponse response = this.client.get("/latest/meta-data/" + key);
            if (response != null) {
                map.put(key, response.asString());
            }
        }
        catch (SdkClientException e) {
            logger.debug("Unable to read property /latest/meta-data/" + key + ", exception message: " + e.getMessage());
        }
        catch (RuntimeException e) {
            logger.debug("Exception occurred reading property /latest/meta-data/" + key + ", exception message: " + e.getMessage());
        }
    }
}

