/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.secretsmanager;

import io.awspring.cloud.autoconfigure.AwsSyncClientCustomizer;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerClientCustomizer;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerProperties;
import io.awspring.cloud.autoconfigure.core.AwsAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

@AutoConfiguration
@EnableConfigurationProperties(value={SecretsManagerProperties.class})
@ConditionalOnClass(value={SecretsManagerClient.class})
@AutoConfigureAfter(value={AwsAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.aws.secretsmanager.enabled"}, havingValue="true", matchIfMissing=true)
public class SecretsManagerAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public SecretsManagerClient secretsManagerClient(SecretsManagerProperties properties, AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsClientCustomizer<SecretsManagerClientBuilder>> customizer, ObjectProvider<AwsConnectionDetails> connectionDetails, ObjectProvider<SecretsManagerClientCustomizer> secretsManagerClientCustomizers, ObjectProvider<AwsSyncClientCustomizer> awsSyncClientCustomizers) {
        return (SecretsManagerClient)awsClientBuilderConfigurer.configureSyncClient(SecretsManagerClient.builder(), properties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), (AwsClientCustomizer)customizer.getIfAvailable(), secretsManagerClientCustomizers.orderedStream(), awsSyncClientCustomizers.orderedStream()).build();
    }
}

