/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.secretsmanager;

import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerProperties;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

@AutoConfiguration
@EnableConfigurationProperties(value={SecretsManagerProperties.class})
@ConditionalOnClass(value={SecretsManagerClient.class})
@AutoConfigureAfter(value={CredentialsProviderAutoConfiguration.class, RegionProviderAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.aws.secretsmanager.enabled"}, havingValue="true", matchIfMissing=true)
public class SecretsManagerAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public SecretsManagerClient secretsManagerClient(SecretsManagerProperties properties, AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsClientCustomizer<SecretsManagerClientBuilder>> customizer, ObjectProvider<AwsConnectionDetails> connectionDetails) {
        return (SecretsManagerClient)awsClientBuilderConfigurer.configure(SecretsManagerClient.builder(), properties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), (AwsClientCustomizer)customizer.getIfAvailable()).build();
    }
}

