/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.s3.properties;

import io.awspring.cloud.autoconfigure.AwsClientProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3CrtClientProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3TransferManagerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.s3.S3Configuration;

@ConfigurationProperties(prefix="spring.cloud.aws.s3")
public class S3Properties
extends AwsClientProperties {
    public static final String PREFIX = "spring.cloud.aws.s3";
    @Nullable
    private Boolean accelerateModeEnabled;
    @Nullable
    private Boolean checksumValidationEnabled;
    @Nullable
    private Boolean chunkedEncodingEnabled;
    @Nullable
    private Boolean pathStyleAccessEnabled;
    @Nullable
    private Boolean useArnRegionEnabled;
    @Nullable
    private Boolean crossRegionEnabled;
    @Nullable
    @NestedConfigurationProperty
    private S3TransferManagerProperties transferManager;
    @Nullable
    @NestedConfigurationProperty
    private S3CrtClientProperties crt;

    @Nullable
    public Boolean getAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public void setAccelerateModeEnabled(@Nullable Boolean accelerateModeEnabled) {
        this.accelerateModeEnabled = accelerateModeEnabled;
    }

    @Nullable
    public Boolean getChecksumValidationEnabled() {
        return this.checksumValidationEnabled;
    }

    public void setChecksumValidationEnabled(@Nullable Boolean checksumValidationEnabled) {
        this.checksumValidationEnabled = checksumValidationEnabled;
    }

    @Nullable
    public Boolean getChunkedEncodingEnabled() {
        return this.chunkedEncodingEnabled;
    }

    public void setChunkedEncodingEnabled(@Nullable Boolean chunkedEncodingEnabled) {
        this.chunkedEncodingEnabled = chunkedEncodingEnabled;
    }

    @Nullable
    public Boolean getPathStyleAccessEnabled() {
        return this.pathStyleAccessEnabled;
    }

    public void setPathStyleAccessEnabled(@Nullable Boolean pathStyleAccessEnabled) {
        this.pathStyleAccessEnabled = pathStyleAccessEnabled;
    }

    @Nullable
    public Boolean getUseArnRegionEnabled() {
        return this.useArnRegionEnabled;
    }

    public void setUseArnRegionEnabled(@Nullable Boolean useArnRegionEnabled) {
        this.useArnRegionEnabled = useArnRegionEnabled;
    }

    @Nullable
    public Boolean getCrossRegionEnabled() {
        return this.crossRegionEnabled;
    }

    public void setCrossRegionEnabled(@Nullable Boolean crossRegionEnabled) {
        this.crossRegionEnabled = crossRegionEnabled;
    }

    @Nullable
    public S3TransferManagerProperties getTransferManager() {
        return this.transferManager;
    }

    public void setTransferManager(@Nullable S3TransferManagerProperties transferManager) {
        this.transferManager = transferManager;
    }

    @Nullable
    public S3CrtClientProperties getCrt() {
        return this.crt;
    }

    public void setCrt(@Nullable S3CrtClientProperties crt) {
        this.crt = crt;
    }

    public S3Configuration toS3Configuration() {
        S3Configuration.Builder config = S3Configuration.builder();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(this::getAccelerateModeEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).accelerateModeEnabled(arg_0));
        propertyMapper.from(this::getChecksumValidationEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).checksumValidationEnabled(arg_0));
        propertyMapper.from(this::getChunkedEncodingEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).chunkedEncodingEnabled(arg_0));
        propertyMapper.from(this::getPathStyleAccessEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).pathStyleAccessEnabled(arg_0));
        propertyMapper.from(this::getUseArnRegionEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).useArnRegionEnabled(arg_0));
        return (S3Configuration)config.build();
    }
}

