/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.sns;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.sns.SnsProperties;
import io.awspring.cloud.sns.configuration.NotificationHandlerMethodArgumentResolverConfigurationUtils;
import io.awspring.cloud.sns.core.SnsOperations;
import io.awspring.cloud.sns.core.SnsTemplate;
import io.awspring.cloud.sns.core.TopicArnResolver;
import io.awspring.cloud.sns.sms.SnsSmsOperations;
import io.awspring.cloud.sns.sms.SnsSmsTemplate;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;

@AutoConfiguration
@ConditionalOnClass(value={SnsClient.class, SnsTemplate.class})
@EnableConfigurationProperties(value={SnsProperties.class})
@AutoConfigureAfter(value={CredentialsProviderAutoConfiguration.class, RegionProviderAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.aws.sns.enabled"}, havingValue="true", matchIfMissing=true)
public class SnsAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public SnsClient snsClient(SnsProperties properties, AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsClientCustomizer<SnsClientBuilder>> configurer) {
        return (SnsClient)awsClientBuilderConfigurer.configure(SnsClient.builder(), properties, (AwsClientCustomizer)configurer.getIfAvailable()).build();
    }

    @ConditionalOnMissingBean(value={SnsOperations.class})
    @Bean
    public SnsTemplate snsTemplate(SnsClient snsClient, Optional<ObjectMapper> objectMapper, Optional<TopicArnResolver> topicArnResolver) {
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setSerializedPayloadClass(String.class);
        objectMapper.ifPresent(arg_0 -> ((MappingJackson2MessageConverter)converter).setObjectMapper(arg_0));
        return topicArnResolver.map(it -> new SnsTemplate(snsClient, it, (MessageConverter)converter)).orElseGet(() -> new SnsTemplate(snsClient, (MessageConverter)converter));
    }

    @ConditionalOnMissingBean(value={SnsSmsOperations.class})
    @Bean
    public SnsSmsTemplate snsSmsTemplate(SnsClient snsClient) {
        return new SnsSmsTemplate(snsClient);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    static class SnsWebConfiguration {
        SnsWebConfiguration() {
        }

        @Bean
        public WebMvcConfigurer snsWebMvcConfigurer(final SnsClient snsClient) {
            return new WebMvcConfigurer(){

                public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
                    resolvers.add(NotificationHandlerMethodArgumentResolverConfigurationUtils.getNotificationHandlerMethodArgumentResolver((SnsClient)snsClient));
                }
            };
        }
    }
}

