/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3Properties;
import io.awspring.cloud.s3.InMemoryBufferingS3OutputStreamProvider;
import io.awspring.cloud.s3.Jackson2JsonS3ObjectConverter;
import io.awspring.cloud.s3.PropertiesS3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3ObjectConverter;
import io.awspring.cloud.s3.S3Operations;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.S3ProtocolResolver;
import io.awspring.cloud.s3.S3Template;
import io.awspring.cloud.s3.crossregion.CrossRegionS3Client;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

@AutoConfiguration
@ConditionalOnClass(value={S3Client.class, S3OutputStreamProvider.class})
@EnableConfigurationProperties(value={S3Properties.class, AwsProperties.class})
@Import(value={S3ProtocolResolver.class})
@ConditionalOnProperty(name={"spring.cloud.aws.s3.enabled"}, havingValue="true", matchIfMissing=true)
public class S3AutoConfiguration {
    private final S3Properties properties;

    public S3AutoConfiguration(S3Properties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    S3ClientBuilder s3ClientBuilder(AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsClientCustomizer<S3ClientBuilder>> configurer) {
        S3ClientBuilder builder = awsClientBuilderConfigurer.configure(S3Client.builder(), this.properties, (AwsClientCustomizer)configurer.getIfAvailable());
        builder.serviceConfiguration(this.s3ServiceConfiguration());
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean(value={S3Operations.class})
    @ConditionalOnBean(value={S3ObjectConverter.class})
    S3Template s3Template(S3Client s3Client, S3OutputStreamProvider s3OutputStreamProvider, S3ObjectConverter s3ObjectConverter) {
        return new S3Template(s3Client, s3OutputStreamProvider, s3ObjectConverter);
    }

    private S3Configuration s3ServiceConfiguration() {
        S3Configuration.Builder config = S3Configuration.builder();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(this.properties::getAccelerateModeEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).accelerateModeEnabled(arg_0));
        propertyMapper.from(this.properties::getChecksumValidationEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).checksumValidationEnabled(arg_0));
        propertyMapper.from(this.properties::getChunkedEncodingEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).chunkedEncodingEnabled(arg_0));
        propertyMapper.from(this.properties::getPathStyleAccessEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).pathStyleAccessEnabled(arg_0));
        propertyMapper.from(this.properties::getUseArnRegionEnabled).whenNonNull().to(arg_0 -> ((S3Configuration.Builder)config).useArnRegionEnabled(arg_0));
        return (S3Configuration)config.build();
    }

    @Bean
    @ConditionalOnMissingBean
    S3OutputStreamProvider inMemoryBufferingS3StreamProvider(S3Client s3Client, Optional<S3ObjectContentTypeResolver> contentTypeResolver) {
        return new InMemoryBufferingS3OutputStreamProvider(s3Client, contentTypeResolver.orElseGet(PropertiesS3ObjectContentTypeResolver::new));
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    static class Jackson2JsonS3ObjectConverterConfiguration {
        Jackson2JsonS3ObjectConverterConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        S3ObjectConverter s3ObjectConverter(Optional<ObjectMapper> objectMapper) {
            return new Jackson2JsonS3ObjectConverter(objectMapper.orElseGet(ObjectMapper::new));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.awspring.cloud.s3.crossregion.CrossRegionS3Client"})
    static class StandardS3ClientConfiguration {
        StandardS3ClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        S3Client s3Client(S3ClientBuilder s3ClientBuilder) {
            return (S3Client)s3ClientBuilder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CrossRegionS3Client.class})
    static class CrossRegionS3ClientConfiguration {
        CrossRegionS3ClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        S3Client s3Client(S3ClientBuilder s3ClientBuilder) {
            return new CrossRegionS3Client(s3ClientBuilder);
        }
    }
}

