/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.core;

import io.awspring.cloud.autoconfigure.core.CredentialsProperties;
import io.awspring.cloud.autoconfigure.core.Profile;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.profiles.ProfileFile;

@AutoConfiguration
@ConditionalOnClass(value={AwsCredentialsProvider.class, ProfileFile.class})
@EnableConfigurationProperties(value={CredentialsProperties.class})
public class CredentialsProviderAutoConfiguration {
    private final CredentialsProperties properties;

    public CredentialsProviderAutoConfiguration(CredentialsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public AwsCredentialsProvider credentialsProvider() {
        return CredentialsProviderAutoConfiguration.createCredentialsProvider(this.properties);
    }

    public static AwsCredentialsProvider createCredentialsProvider(CredentialsProperties properties) {
        Profile profile;
        ArrayList<Object> providers = new ArrayList<Object>();
        if (StringUtils.hasText((String)properties.getAccessKey()) && StringUtils.hasText((String)properties.getSecretKey())) {
            providers.add(CredentialsProviderAutoConfiguration.createStaticCredentialsProvider(properties));
        }
        if (properties.isInstanceProfile()) {
            providers.add(InstanceProfileCredentialsProvider.create());
        }
        if ((profile = properties.getProfile()) != null && profile.getName() != null) {
            providers.add(CredentialsProviderAutoConfiguration.createProfileCredentialProvider(profile));
        }
        if (providers.isEmpty()) {
            return DefaultCredentialsProvider.create();
        }
        if (providers.size() == 1) {
            return (AwsCredentialsProvider)providers.get(0);
        }
        return AwsCredentialsProviderChain.builder().credentialsProviders(providers).build();
    }

    private static StaticCredentialsProvider createStaticCredentialsProvider(CredentialsProperties properties) {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)properties.getAccessKey(), (String)properties.getSecretKey()));
    }

    private static ProfileCredentialsProvider createProfileCredentialProvider(Profile profile) {
        ProfileFile profileFile = profile.getPath() != null ? ProfileFile.builder().type(ProfileFile.Type.CREDENTIALS).content(Paths.get(profile.getPath(), new String[0])).build() : ProfileFile.defaultProfileFile();
        return ProfileCredentialsProvider.builder().profileName(profile.getName()).profileFile(profileFile).build();
    }
}

