/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.reload;

import io.awspring.cloud.autoconfigure.config.reload.ConfigurationChangeDetector;
import io.awspring.cloud.autoconfigure.config.reload.ConfigurationUpdateStrategy;
import io.awspring.cloud.autoconfigure.config.reload.ReloadProperties;
import io.awspring.cloud.core.config.AwsPropertySource;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public class PollingAwsPropertySourceChangeDetector<T extends AwsPropertySource<?, ?>>
extends ConfigurationChangeDetector<T>
implements InitializingBean {
    protected Log log = LogFactory.getLog(this.getClass());
    private final TaskScheduler taskExecutor;

    public PollingAwsPropertySourceChangeDetector(ReloadProperties properties, Class<T> clazz, ConfigurationUpdateStrategy strategy, TaskScheduler taskExecutor, ConfigurableEnvironment environment) {
        super(properties, strategy, environment, clazz);
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() {
        this.log.info((Object)"Polling configurations change detector activated");
        PeriodicTrigger trigger = new PeriodicTrigger(this.properties.getPeriod());
        trigger.setInitialDelay(this.properties.getPeriod());
        this.taskExecutor.schedule(this::executeCycle, (Trigger)trigger);
    }

    public void executeCycle() {
        if (this.properties.isEnabled()) {
            List currentSecretSources;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Polling for changes in secrets");
            }
            if (!(currentSecretSources = this.locateMapPropertySources(this.environment)).isEmpty()) {
                for (AwsPropertySource propertySource : currentSecretSources) {
                    AwsPropertySource clone = propertySource.copy();
                    clone.init();
                    if (!this.changed((EnumerablePropertySource<?>)propertySource, (EnumerablePropertySource<?>)clone)) continue;
                    this.reloadProperties();
                }
            }
        }
    }
}

