/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.context;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import io.awspring.cloud.autoconfigure.context.properties.AwsCredentialsProperties;
import io.awspring.cloud.core.config.AmazonWebserviceClientConfigurationUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AwsCredentialsProperties.class})
@Import(value={Registrar.class})
@ConditionalOnClass(value={AWSCredentialsProvider.class})
public class ContextCredentialsAutoConfiguration {

    static class Registrar
    implements EnvironmentAware,
    ImportBeanDefinitionRegistrar {
        private Environment environment;

        Registrar() {
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition("credentialsProvider")) {
                registry.registerBeanDefinition("credentialsProvider", this.resolveCredentialsProviderBeanDefinition(this.resolveCredentialsProviders(this.awsCredentialsProperties())));
                AmazonWebserviceClientConfigurationUtils.replaceDefaultCredentialsProvider((BeanDefinitionRegistry)registry, (String)"credentialsProvider");
            }
        }

        private BeanDefinition resolveCredentialsProviderBeanDefinition(List<AWSCredentialsProvider> providers) {
            return providers.isEmpty() ? BeanDefinitionBuilder.genericBeanDefinition(DefaultAWSCredentialsProviderChain.class).getBeanDefinition() : BeanDefinitionBuilder.genericBeanDefinition(AWSCredentialsProviderChain.class).addConstructorArgValue(providers).getBeanDefinition();
        }

        private AwsCredentialsProperties awsCredentialsProperties() {
            return (AwsCredentialsProperties)Binder.get((Environment)this.environment).bindOrCreate("cloud.aws.credentials", AwsCredentialsProperties.class);
        }

        private List<AWSCredentialsProvider> resolveCredentialsProviders(AwsCredentialsProperties properties) {
            ArrayList<AWSCredentialsProvider> providers = new ArrayList<AWSCredentialsProvider>();
            if (StringUtils.hasText((String)properties.getAccessKey()) && StringUtils.hasText((String)properties.getSecretKey())) {
                providers.add((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(properties.getAccessKey(), properties.getSecretKey())));
            }
            if (properties.isInstanceProfile()) {
                providers.add((AWSCredentialsProvider)new EC2ContainerCredentialsProviderWrapper());
            }
            if (properties.getProfileName() != null) {
                providers.add((AWSCredentialsProvider)(properties.getProfilePath() != null ? new ProfileCredentialsProvider(properties.getProfilePath(), properties.getProfileName()) : new ProfileCredentialsProvider(properties.getProfileName())));
            }
            return providers;
        }
    }
}

