/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal;

public class EnvironmentDetection {
    private final ClassLoader classLoader;
    private Boolean jbossVFSv2;
    private Boolean jbossVFSv3;
    private Boolean osgi;

    public EnvironmentDetection(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isJBossVFSv2() {
        if (this.jbossVFSv2 == null) {
            this.jbossVFSv2 = EnvironmentDetection.isPresent("org.jboss.virtual.VFS", this.classLoader);
        }
        return this.jbossVFSv2;
    }

    public boolean isJBossVFSv3() {
        if (this.jbossVFSv3 == null) {
            this.jbossVFSv3 = EnvironmentDetection.isPresent("org.jboss.vfs.VFS", this.classLoader);
        }
        return this.jbossVFSv3;
    }

    public boolean isOsgi() {
        if (this.osgi == null) {
            this.osgi = EnvironmentDetection.isPresent("org.osgi.framework.Bundle", this.classLoader);
        }
        return this.osgi;
    }

    public static boolean isAndroid() {
        return "Android Runtime".equals(System.getProperty("java.runtime.name"));
    }

    private static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

