/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.buffer.HeapBuffer;
import io.atomix.catalyst.util.Assert;

public final class SnapshotDescriptor
implements AutoCloseable {
    public static final int BYTES = 64;
    private Buffer buffer;
    private final long index;
    private final long timestamp;
    private boolean locked;

    public static Builder builder() {
        return new Builder((Buffer)HeapBuffer.allocate((long)64L));
    }

    public static Builder builder(Buffer buffer) {
        return new Builder(buffer);
    }

    public SnapshotDescriptor(Buffer buffer) {
        this.buffer = (Buffer)Assert.notNull((Object)buffer, (String)"buffer");
        this.index = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.locked = buffer.readBoolean();
        buffer.skip(64L - buffer.position());
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public boolean locked() {
        return this.locked;
    }

    public void lock() {
        ((Buffer)this.buffer.flush()).writeBoolean(16L, true).flush();
        this.locked = true;
    }

    SnapshotDescriptor copyTo(Buffer buffer) {
        this.buffer = (Buffer)buffer.writeLong(this.index).writeLong(this.timestamp).writeBoolean(this.locked).skip(64L - buffer.position()).flush();
        return this;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public void delete() {
        if (this.buffer instanceof FileBuffer) {
            ((FileBuffer)this.buffer).delete();
        }
    }

    public static class Builder {
        private final Buffer buffer;

        private Builder(Buffer buffer) {
            this.buffer = (Buffer)Assert.notNull((Object)buffer, (String)"buffer");
        }

        public Builder withIndex(long index) {
            this.buffer.writeLong(0L, index);
            return this;
        }

        public Builder withTimestamp(long timestamp) {
            this.buffer.writeLong(8L, timestamp);
            return this;
        }

        public SnapshotDescriptor build() {
            return new SnapshotDescriptor(this.buffer);
        }
    }
}

