/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.transport.Connection;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.CommandRequest;
import io.atomix.copycat.protocol.CommandResponse;
import io.atomix.copycat.protocol.ConnectRequest;
import io.atomix.copycat.protocol.ConnectResponse;
import io.atomix.copycat.protocol.KeepAliveRequest;
import io.atomix.copycat.protocol.KeepAliveResponse;
import io.atomix.copycat.protocol.QueryRequest;
import io.atomix.copycat.protocol.QueryResponse;
import io.atomix.copycat.protocol.RegisterRequest;
import io.atomix.copycat.protocol.RegisterResponse;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.UnregisterRequest;
import io.atomix.copycat.protocol.UnregisterResponse;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.InstallRequest;
import io.atomix.copycat.server.protocol.InstallResponse;
import io.atomix.copycat.server.protocol.JoinRequest;
import io.atomix.copycat.server.protocol.JoinResponse;
import io.atomix.copycat.server.protocol.LeaveRequest;
import io.atomix.copycat.server.protocol.LeaveResponse;
import io.atomix.copycat.server.protocol.PollRequest;
import io.atomix.copycat.server.protocol.PollResponse;
import io.atomix.copycat.server.protocol.ReconfigureRequest;
import io.atomix.copycat.server.protocol.ReconfigureResponse;
import io.atomix.copycat.server.protocol.VoteRequest;
import io.atomix.copycat.server.protocol.VoteResponse;
import io.atomix.copycat.server.state.InactiveState;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerState;
import java.util.concurrent.CompletableFuture;

class ReserveState
extends InactiveState {
    public ReserveState(ServerContext context) {
        super(context);
    }

    @Override
    public CopycatServer.State type() {
        return CopycatServer.State.RESERVE;
    }

    @Override
    public CompletableFuture<ServerState> open() {
        return ((CompletableFuture)super.open().thenRun(() -> {
            if (this.type() == CopycatServer.State.RESERVE) {
                this.context.reset();
            }
        })).thenApply(v -> this);
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        this.context.setCommitIndex(request.commitIndex());
        this.context.setGlobalIndex(request.globalIndex());
        return CompletableFuture.completedFuture(this.logResponse(((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(true).withLogIndex(0L).build()));
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), 0);
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
    }

    @Override
    public CompletableFuture<CommandResponse> command(CommandRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        return ((CompletableFuture)this.forward(request).exceptionally(error -> (CommandResponse)((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        return ((CompletableFuture)this.forward(request).exceptionally(error -> (QueryResponse)((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<RegisterResponse> register(RegisterRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        return ((CompletableFuture)this.forward(request).exceptionally(error -> ((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<ConnectResponse> connect(ConnectRequest request, Connection connection) {
        this.context.checkThread();
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((ConnectResponse.Builder)((ConnectResponse.Builder)ConnectResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        return ((CompletableFuture)this.forward(request).exceptionally(error -> ((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<UnregisterResponse> unregister(UnregisterRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((UnregisterResponse.Builder)((UnregisterResponse.Builder)UnregisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        return ((CompletableFuture)this.forward(request).exceptionally(error -> (UnregisterResponse)((UnregisterResponse.Builder)((UnregisterResponse.Builder)UnregisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<JoinResponse> join(JoinRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        return ((CompletableFuture)this.forward(request).exceptionally(error -> (JoinResponse)((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<ReconfigureResponse> reconfigure(ReconfigureRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        return ((CompletableFuture)this.forward(request).exceptionally(error -> (ReconfigureResponse)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<LeaveResponse> leave(LeaveRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        return ((CompletableFuture)this.forward(request).exceptionally(error -> (LeaveResponse)((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<InstallResponse> install(InstallRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
    }

    @Override
    public CompletableFuture<Void> close() {
        return super.close().thenRun(() -> {
            if (this.type() == CopycatServer.State.RESERVE) {
                this.context.reset();
            }
        });
    }
}

