/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.session;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.session.ClientSession;
import io.atomix.copycat.session.Session;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientSessionState {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSession.class);
    private final String clientId;
    private volatile long sessionId;
    private volatile Session.State state = Session.State.CLOSED;
    private long commandRequest;
    private long commandResponse;
    private long responseIndex;
    private long eventIndex;
    private long unstableSince;
    private long unstabilityTimeout;
    private final Set<Listener<Session.State>> changeListeners = new CopyOnWriteArraySet<Listener<Session.State>>();

    ClientSessionState(String clientId) {
        this(clientId, Duration.ZERO);
    }

    ClientSessionState(String clientId, Duration unstabilityTimeout) {
        this.clientId = (String)Assert.notNull((Object)clientId, (String)"clientId");
        this.unstabilityTimeout = ((Duration)Assert.notNull((Object)unstabilityTimeout, (String)"unstabilityTimeout")).toMillis();
    }

    public String getClientId() {
        return this.clientId;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public ClientSessionState setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.responseIndex = sessionId;
        this.eventIndex = sessionId;
        return this;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public Session.State getState() {
        return this.state;
    }

    public ClientSessionState setState(Session.State state) {
        if (state != Session.State.UNSTABLE) {
            if (this.state != state) {
                return this.setStateAndCallListeners(state);
            }
        } else if (this.state == Session.State.UNSTABLE) {
            if (this.unstabilityTimeout > 0L && System.currentTimeMillis() - this.unstableSince > this.unstabilityTimeout) {
                return this.setStateAndCallListeners(Session.State.STALE);
            }
        } else if (this.state != Session.State.STALE) {
            this.unstableSince = System.currentTimeMillis();
            return this.setStateAndCallListeners(state);
        }
        return this;
    }

    private ClientSessionState setStateAndCallListeners(Session.State state) {
        this.state = state;
        this.changeListeners.forEach(l -> l.accept((Object)state));
        return this;
    }

    public Listener<Session.State> onStateChange(final Consumer<Session.State> callback) {
        Listener<Session.State> listener = new Listener<Session.State>(){

            public void accept(Session.State state) {
                callback.accept(state);
            }

            public void close() {
                ClientSessionState.this.changeListeners.remove(this);
            }
        };
        this.changeListeners.add(listener);
        return listener;
    }

    public ClientSessionState setCommandRequest(long commandRequest) {
        this.commandRequest = commandRequest;
        return this;
    }

    public long getCommandRequest() {
        return this.commandRequest;
    }

    public long nextCommandRequest() {
        return ++this.commandRequest;
    }

    public ClientSessionState setCommandResponse(long commandResponse) {
        this.commandResponse = commandResponse;
        return this;
    }

    public long getCommandResponse() {
        return this.commandResponse;
    }

    public ClientSessionState setResponseIndex(long responseIndex) {
        this.responseIndex = Math.max(this.responseIndex, responseIndex);
        return this;
    }

    public long getResponseIndex() {
        return this.responseIndex;
    }

    public ClientSessionState setEventIndex(long eventIndex) {
        this.eventIndex = eventIndex;
        return this;
    }

    public long getEventIndex() {
        return this.eventIndex;
    }
}

