/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.AbstractBytes;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.HeapBytes;
import io.atomix.catalyst.buffer.WrappedBytes;
import io.atomix.catalyst.buffer.util.HeapMemory;
import io.atomix.catalyst.buffer.util.NativeMemory;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public abstract class NativeBytes
extends AbstractBytes {
    private static final boolean NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    protected NativeMemory memory;

    protected NativeBytes(NativeMemory memory) {
        this.memory = memory;
    }

    @Override
    public long size() {
        return this.memory.size();
    }

    @Override
    public Bytes resize(long newSize) {
        this.memory = this.memory.allocator().reallocate(this.memory, newSize);
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public Bytes zero() {
        return this.zero(0L, this.memory.size());
    }

    @Override
    public Bytes zero(long offset) {
        return this.zero(offset, this.memory.size() - offset);
    }

    @Override
    public Bytes zero(long offset, long length) {
        this.memory.unsafe().setMemory(this.memory.address(offset), length, (byte)0);
        return this;
    }

    @Override
    public Bytes read(long position, Bytes bytes, long offset, long length) {
        this.checkRead(position, length);
        if (bytes instanceof WrappedBytes) {
            bytes = ((WrappedBytes)bytes).root();
        }
        if (bytes instanceof NativeBytes) {
            this.memory.unsafe().copyMemory(this.memory.address(position), ((NativeBytes)bytes).memory.address(), length);
        } else if (bytes instanceof HeapBytes) {
            this.memory.unsafe().copyMemory(null, this.memory.address(position), ((HeapBytes)bytes).memory.array(), ((HeapBytes)bytes).memory.address(offset), length);
        } else {
            int i = 0;
            while ((long)i < length) {
                bytes.writeByte(offset + (long)i, this.memory.getByte(position + (long)i));
                ++i;
            }
        }
        return this;
    }

    @Override
    public Bytes read(long position, byte[] bytes, long offset, long length) {
        this.checkRead(position, length);
        this.memory.unsafe().copyMemory(null, this.memory.address(position), bytes, HeapMemory.ARRAY_BASE_OFFSET + offset, length);
        return this;
    }

    @Override
    public int readByte(long offset) {
        this.checkRead(offset, 1L);
        return this.memory.getByte(offset);
    }

    @Override
    public int readUnsignedByte(long offset) {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public char readChar(long offset) {
        this.checkRead(offset, 2L);
        return NATIVE_ORDER ? this.memory.getChar(offset) : Character.reverseBytes(this.memory.getChar(offset));
    }

    @Override
    public short readShort(long offset) {
        this.checkRead(offset, 2L);
        return NATIVE_ORDER ? this.memory.getShort(offset) : Short.reverseBytes(this.memory.getShort(offset));
    }

    @Override
    public int readUnsignedShort(long offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    @Override
    public int readMedium(long offset) {
        this.checkRead(offset, 3L);
        return NATIVE_ORDER ? this.memory.getByte(offset) << 16 | (this.memory.getByte(offset + 1L) & 0xFF) << 8 | this.memory.getByte(offset + 2L) & 0xFF : this.memory.getByte(offset + 2L) << 16 | (this.memory.getByte(offset + 1L) & 0xFF) << 8 | this.memory.getByte(offset) & 0xFF;
    }

    @Override
    public int readUnsignedMedium(long offset) {
        this.checkRead(offset, 3L);
        return NATIVE_ORDER ? (this.memory.getByte(offset) & 0xFF) << 16 | (this.memory.getByte(offset + 1L) & 0xFF) << 8 | this.memory.getByte(offset + 2L) & 0xFF : (this.memory.getByte(offset + 2L) & 0xFF) << 16 | (this.memory.getByte(offset + 1L) & 0xFF) << 8 | this.memory.getByte(offset) & 0xFF;
    }

    @Override
    public int readInt(long offset) {
        this.checkRead(offset, 4L);
        return NATIVE_ORDER ? this.memory.getInt(offset) : Integer.reverseBytes(this.memory.getInt(offset));
    }

    @Override
    public long readUnsignedInt(long offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public long readLong(long offset) {
        this.checkRead(offset, 8L);
        return NATIVE_ORDER ? this.memory.getLong(offset) : Long.reverseBytes(this.memory.getLong(offset));
    }

    @Override
    public float readFloat(long offset) {
        return Float.intBitsToFloat(this.readInt(offset));
    }

    @Override
    public double readDouble(long offset) {
        return Double.longBitsToDouble(this.readLong(offset));
    }

    @Override
    public boolean readBoolean(long offset) {
        this.checkRead(offset, 1L);
        return this.memory.getByte(offset) == 1;
    }

    @Override
    public String readString(long offset) {
        if (this.readByte(offset) != 0) {
            byte[] bytes = new byte[this.readUnsignedShort(offset + 1L)];
            this.read(offset + 1L + 2L, bytes, 0L, (long)bytes.length);
            return new String(bytes);
        }
        return null;
    }

    @Override
    public String readUTF8(long offset) {
        if (this.readByte(offset) != 0) {
            byte[] bytes = new byte[this.readUnsignedShort(offset + 1L)];
            this.read(offset + 1L + 2L, bytes, 0L, (long)bytes.length);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public Bytes write(long position, Bytes bytes, long offset, long length) {
        this.checkWrite(position, length);
        if (bytes.size() < length) {
            throw new IllegalArgumentException("length is greater than provided byte array size");
        }
        if (bytes instanceof WrappedBytes) {
            bytes = ((WrappedBytes)bytes).root();
        }
        if (bytes instanceof NativeBytes) {
            this.memory.unsafe().copyMemory(((NativeBytes)bytes).memory.address(offset), this.memory.address(position), length);
        } else if (bytes instanceof HeapBytes) {
            this.memory.unsafe().copyMemory(((HeapBytes)bytes).memory.array(), ((HeapBytes)bytes).memory.address(offset), null, this.memory.address(position), length);
        } else {
            int i = 0;
            while ((long)i < length) {
                this.memory.putByte(position + (long)i, (byte)bytes.readByte(offset + (long)i));
                ++i;
            }
        }
        return this;
    }

    @Override
    public Bytes write(long position, byte[] bytes, long offset, long length) {
        this.checkWrite(position, length);
        if ((long)bytes.length < length) {
            throw new IllegalArgumentException("length is greater than provided byte array length");
        }
        this.memory.unsafe().copyMemory(bytes, HeapMemory.ARRAY_BASE_OFFSET + offset, null, this.memory.address(position), length);
        return this;
    }

    @Override
    public Bytes writeByte(long offset, int b) {
        this.checkWrite(offset, 1L);
        this.memory.putByte(offset, (byte)b);
        return this;
    }

    @Override
    public Bytes writeUnsignedByte(long offset, int b) {
        this.checkWrite(offset, 1L);
        this.memory.putByte(offset, (byte)b);
        return this;
    }

    @Override
    public Bytes writeChar(long offset, char c) {
        this.checkWrite(offset, 2L);
        this.memory.putChar(offset, NATIVE_ORDER ? c : Character.reverseBytes(c));
        return this;
    }

    @Override
    public Bytes writeShort(long offset, short s) {
        this.checkWrite(offset, 2L);
        this.memory.putShort(offset, NATIVE_ORDER ? s : Short.reverseBytes(s));
        return this;
    }

    @Override
    public Bytes writeUnsignedShort(long offset, int s) {
        return this.writeShort(offset, (short)s);
    }

    @Override
    public Bytes writeMedium(long offset, int m) {
        if (NATIVE_ORDER) {
            this.memory.putByte(offset, (byte)(m >>> 16));
            this.memory.putByte(offset + 1L, (byte)(m >>> 8));
            this.memory.putByte(offset + 2L, (byte)m);
        } else {
            this.memory.putByte(offset + 2L, (byte)(m >>> 16));
            this.memory.putByte(offset + 1L, (byte)(m >>> 8));
            this.memory.putByte(offset, (byte)m);
        }
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(long offset, int m) {
        return this.writeMedium(offset, m);
    }

    @Override
    public Bytes writeInt(long offset, int i) {
        this.checkWrite(offset, 4L);
        this.memory.putInt(offset, NATIVE_ORDER ? i : Integer.reverseBytes(i));
        return this;
    }

    @Override
    public Bytes writeUnsignedInt(long offset, long i) {
        return this.writeInt(offset, (int)i);
    }

    @Override
    public Bytes writeLong(long offset, long l) {
        this.checkWrite(offset, 8L);
        this.memory.putLong(offset, NATIVE_ORDER ? l : Long.reverseBytes(l));
        return this;
    }

    @Override
    public Bytes writeFloat(long offset, float f) {
        return this.writeInt(offset, Float.floatToRawIntBits(f));
    }

    @Override
    public Bytes writeDouble(long offset, double d) {
        return this.writeLong(offset, Double.doubleToRawLongBits(d));
    }

    @Override
    public Bytes writeBoolean(long offset, boolean b) {
        return this.writeByte(offset, b ? 1 : 0);
    }

    @Override
    public Bytes writeString(long offset, String s) {
        byte[] bytes = s.getBytes();
        return (Bytes)this.writeUnsignedShort(offset, bytes.length).write(offset + 2L, bytes, 0L, (long)bytes.length);
    }

    @Override
    public Bytes writeUTF8(long offset, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return (Bytes)this.writeUnsignedShort(offset, bytes.length).write(offset + 2L, bytes, 0L, (long)bytes.length);
    }

    @Override
    public Bytes flush() {
        return this;
    }

    @Override
    public void close() {
        this.flush();
        this.memory.free();
        super.close();
    }
}

