/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import io.atomix.utils.concurrent.RetryingFunction;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Retries {
    public static <U, V> Function<U, V> retryable(Function<U, V> base, Class<? extends Throwable> exceptionClass, int maxRetries, int maxDelayBetweenRetries) {
        return new RetryingFunction<U, V>(base, exceptionClass, maxRetries, maxDelayBetweenRetries);
    }

    public static <V> Supplier<V> retryable(Supplier<V> base, Class<? extends Throwable> exceptionClass, int maxRetries, int maxDelayBetweenRetries) {
        return () -> new RetryingFunction<Object, Object>(arg_0 -> Retries.lambda$null$0((Supplier)base, arg_0), exceptionClass, maxRetries, maxDelayBetweenRetries).apply((Object)null);
    }

    public static void randomDelay(int ms) {
        try {
            Thread.sleep(ThreadLocalRandom.current().nextInt(ms));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public static void delay(int ms, int nanos) {
        try {
            Thread.sleep(ms, nanos);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    private Retries() {
    }

    private static /* synthetic */ Object lambda$null$0(Supplier base, Object v) {
        return base.get();
    }
}

