/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atomix.utils.config.ConfigurationException;
import io.atomix.utils.serializer.KryoInputPool;
import io.atomix.utils.serializer.KryoOutputPool;
import io.atomix.utils.serializer.NamespaceConfig;
import io.atomix.utils.serializer.NamespaceTypeConfig;
import io.atomix.utils.serializer.Namespaces;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Namespace
implements KryoFactory,
KryoPool {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int MAX_BUFFER_SIZE = 100000000;
    public static final int FLOATING_ID = -1;
    public static final int INITIAL_ID = 16;
    static final String NO_NAME = "(no name)";
    private static final Logger log = LoggerFactory.getLogger(Namespace.class);
    public static Namespace DEFAULT = Namespace.builder().build();
    private final KryoPool kryoPool = new KryoPool.Builder((KryoFactory)this).softReferences().build();
    private final KryoOutputPool kryoOutputPool = new KryoOutputPool();
    private final KryoInputPool kryoInputPool = new KryoInputPool();
    private final ImmutableList<RegistrationBlock> registeredBlocks;
    private final ClassLoader classLoader;
    private final boolean compatible;
    private final boolean registrationRequired;
    private final String friendlyName;

    public static Builder builder() {
        return new Builder();
    }

    private static List<RegistrationBlock> buildRegistrationBlocks(NamespaceConfig config) {
        ArrayList types = new ArrayList();
        ArrayList<RegistrationBlock> blocks = new ArrayList<RegistrationBlock>();
        blocks.addAll((Collection<RegistrationBlock>)Namespaces.BASIC.registeredBlocks);
        for (NamespaceTypeConfig type : config.getTypes()) {
            try {
                if (type.getId() == null) {
                    types.add(Pair.of((Object)new Class[]{type.getType()}, (Object)type.getSerializer().newInstance()));
                    continue;
                }
                blocks.add(new RegistrationBlock(type.getId(), Collections.singletonList(Pair.of((Object)new Class[]{type.getType()}, (Object)type.getSerializer().newInstance()))));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ConfigurationException("Failed to instantiate serializer from configuration", e);
            }
        }
        blocks.add(new RegistrationBlock(500, types));
        return blocks;
    }

    public Namespace(NamespaceConfig config) {
        this(Namespace.buildRegistrationBlocks(config), Thread.currentThread().getContextClassLoader(), config.isRegistrationRequired(), config.isCompatible(), config.getName());
    }

    private Namespace(List<RegistrationBlock> registeredTypes, ClassLoader classLoader, boolean registrationRequired, boolean compatible, String friendlyName) {
        this.registeredBlocks = ImmutableList.copyOf(registeredTypes);
        this.registrationRequired = registrationRequired;
        this.classLoader = classLoader;
        this.compatible = compatible;
        this.friendlyName = (String)Preconditions.checkNotNull((Object)friendlyName);
    }

    public Namespace populate(int instances) {
        for (int i = 0; i < instances; ++i) {
            this.release(this.create());
        }
        return this;
    }

    public byte[] serialize(Object obj) {
        return this.serialize(obj, 4096);
    }

    public byte[] serialize(Object obj, int bufferSize) {
        return this.kryoOutputPool.run(output -> (byte[])this.kryoPool.run(kryo -> {
            kryo.writeClassAndObject((Output)output, obj);
            output.flush();
            return output.getByteArrayOutputStream().toByteArray();
        }), bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object obj, ByteBuffer buffer) {
        ByteBufferOutput out = new ByteBufferOutput(buffer);
        Kryo kryo = this.borrow();
        try {
            kryo.writeClassAndObject((Output)out, obj);
            out.flush();
        }
        finally {
            this.release(kryo);
        }
    }

    public void serialize(Object obj, OutputStream stream) {
        this.serialize(obj, stream, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object obj, OutputStream stream, int bufferSize) {
        ByteBufferOutput out = new ByteBufferOutput(stream, bufferSize);
        Kryo kryo = this.borrow();
        try {
            kryo.writeClassAndObject((Output)out, obj);
            out.flush();
        }
        finally {
            this.release(kryo);
        }
    }

    public <T> T deserialize(byte[] bytes) {
        return (T)this.kryoInputPool.run(input -> {
            input.setInputStream((InputStream)new ByteArrayInputStream(bytes));
            return this.kryoPool.run(kryo -> {
                Object obj = kryo.readClassAndObject(input);
                return obj;
            });
        }, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(ByteBuffer buffer) {
        ByteBufferInput in = new ByteBufferInput(buffer);
        Kryo kryo = this.borrow();
        try {
            Object obj;
            Object object = obj = kryo.readClassAndObject((Input)in);
            return (T)object;
        }
        finally {
            this.release(kryo);
        }
    }

    public <T> T deserialize(InputStream stream) {
        return this.deserialize(stream, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(InputStream stream, int bufferSize) {
        ByteBufferInput in = new ByteBufferInput(stream, bufferSize);
        Kryo kryo = this.borrow();
        try {
            Object obj;
            Object object = obj = kryo.readClassAndObject((Input)in);
            return (T)object;
        }
        finally {
            this.release(kryo);
        }
    }

    private String friendlyName() {
        return this.friendlyName;
    }

    public int size() {
        return (int)this.registeredBlocks.stream().flatMap(block -> block.types().stream()).count();
    }

    public Kryo create() {
        log.trace("Creating Kryo instance for {}", (Object)this);
        Kryo kryo = new Kryo();
        kryo.setClassLoader(this.classLoader);
        kryo.setRegistrationRequired(this.registrationRequired);
        if (this.compatible) {
            kryo.setDefaultSerializer(CompatibleFieldSerializer::new);
        }
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        for (RegistrationBlock block : this.registeredBlocks) {
            int id = block.begin();
            if (id == -1) {
                id = kryo.getNextRegistrationId();
            }
            for (Pair entry : block.types()) {
                this.register(kryo, (Class[])entry.getLeft(), (Serializer)entry.getRight(), id++);
            }
        }
        return kryo;
    }

    private void register(Kryo kryo, Class<?>[] types, Serializer<?> serializer, int id) {
        Registration existing = kryo.getRegistration(id);
        if (existing != null) {
            boolean matches = false;
            Class<?>[] classArray = types;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> type = classArray[i];
                if (existing.getType() != type) continue;
                matches = true;
                break;
            }
            if (!matches) {
                log.error("{}: Failed to register {} as {}, {} was already registered.", new Object[]{this.friendlyName(), types, id, existing.getType()});
                throw new IllegalStateException(String.format("Failed to register %s as %s, %s was already registered.", Arrays.toString(types), id, existing.getType()));
            }
        }
        for (Class<?> type : types) {
            Registration r = serializer == null ? kryo.register(type, id) : kryo.register(type, serializer, id);
            if (r.getId() != id) {
                log.debug("{}: {} already registered as {}. Skipping {}.", new Object[]{this.friendlyName(), r.getType(), r.getId(), id});
            }
            log.trace("{} registered as {}", (Object)r.getType(), (Object)r.getId());
        }
    }

    public Kryo borrow() {
        return this.kryoPool.borrow();
    }

    public void release(Kryo kryo) {
        this.kryoPool.release(kryo);
    }

    public <T> T run(KryoCallback<T> callback) {
        return (T)this.kryoPool.run(callback);
    }

    public String toString() {
        if (this.friendlyName != NO_NAME) {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("friendlyName", (Object)this.friendlyName).toString();
        }
        return MoreObjects.toStringHelper(this.getClass()).add("registeredBlocks", this.registeredBlocks).toString();
    }

    static final class RegistrationBlock {
        private final int begin;
        private final ImmutableList<Pair<Class<?>[], Serializer<?>>> types;

        public RegistrationBlock(int begin, List<Pair<Class<?>[], Serializer<?>>> types) {
            this.begin = begin;
            this.types = ImmutableList.copyOf(types);
        }

        public int begin() {
            return this.begin;
        }

        public ImmutableList<Pair<Class<?>[], Serializer<?>>> types() {
            return this.types;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("begin", this.begin).add("types", this.types).toString();
        }

        public int hashCode() {
            return this.types.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RegistrationBlock) {
                RegistrationBlock that = (RegistrationBlock)obj;
                return Objects.equals(this.types, that.types);
            }
            return false;
        }
    }

    public static final class Builder {
        private int blockHeadId = 16;
        private List<Pair<Class<?>[], Serializer<?>>> types = new ArrayList();
        private List<RegistrationBlock> blocks = new ArrayList<RegistrationBlock>();
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private boolean registrationRequired = true;
        private boolean compatible = false;

        public Namespace build() {
            return this.build(Namespace.NO_NAME);
        }

        public Namespace build(String friendlyName) {
            if (!this.types.isEmpty()) {
                this.blocks.add(new RegistrationBlock(this.blockHeadId, this.types));
            }
            return new Namespace(this.blocks, this.classLoader, this.registrationRequired, this.compatible, friendlyName).populate(1);
        }

        public Builder nextId(int id) {
            if (!this.types.isEmpty()) {
                if (id != -1 && id < this.blockHeadId + this.types.size() && log.isWarnEnabled()) {
                    log.warn("requested nextId {} could potentially overlap with existing registrations {}+{} ", new Object[]{id, this.blockHeadId, this.types.size(), new RuntimeException()});
                }
                this.blocks.add(new RegistrationBlock(this.blockHeadId, this.types));
                this.types = new ArrayList();
            }
            this.blockHeadId = id;
            return this;
        }

        public Builder register(Class<?> ... expectedTypes) {
            for (Class<?> clazz : expectedTypes) {
                this.types.add(Pair.of((Object)new Class[]{clazz}, null));
            }
            return this;
        }

        public Builder register(Serializer<?> serializer, Class<?> ... classes) {
            this.types.add(Pair.of(classes, (Object)Preconditions.checkNotNull(serializer)));
            return this;
        }

        private Builder register(RegistrationBlock block) {
            if (block.begin() != -1) {
                this.nextId(block.begin());
                this.blocks.add(block);
                this.nextId(block.begin() + block.types().size());
            } else {
                int addedBlockBegin = this.blockHeadId + this.types.size();
                this.nextId(addedBlockBegin);
                this.blocks.add(new RegistrationBlock(addedBlockBegin, (List<Pair<Class<?>[], Serializer<?>>>)block.types()));
                this.nextId(addedBlockBegin + block.types().size());
            }
            return this;
        }

        public Builder register(Namespace ns) {
            if (this.blocks.containsAll((Collection<?>)ns.registeredBlocks)) {
                log.debug("Ignoring {}, already registered.", (Object)ns);
                return this;
            }
            for (RegistrationBlock block : ns.registeredBlocks) {
                this.register(block);
            }
            return this;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder setCompatible(boolean compatible) {
            this.compatible = compatible;
            return this;
        }

        public Builder setRegistrationRequired(boolean registrationRequired) {
            this.registrationRequired = registrationRequired;
            return this;
        }
    }
}

