/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public final class Services {
    private static final Map<Class, Object> services = Maps.newConcurrentMap();

    public static <T> T load(Class<T> serviceClass) {
        return (T)services.computeIfAbsent(serviceClass, s -> ServiceLoader.load(serviceClass).iterator().next());
    }

    public static <T> Collection<T> loadAll(Class<T> serviceClass) {
        ArrayList<T> services = new ArrayList<T>();
        Iterator<T> iterator = ServiceLoader.load(serviceClass).iterator();
        while (iterator.hasNext()) {
            services.add(iterator.next());
        }
        return services;
    }

    private Services() {
    }
}

