/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.Preconditions;
import io.atomix.primitive.PrimitiveProtocol;
import io.atomix.primitive.Recovery;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RaftProtocol
implements PrimitiveProtocol {
    public static final PrimitiveProtocol.Type TYPE = new PrimitiveProtocol.Type(){};
    private final String group;
    private final Duration minTimeout;
    private final Duration maxTimeout;
    private final ReadConsistency readConsistency;
    private final CommunicationStrategy communicationStrategy;
    private final Recovery recoveryStrategy;
    private final int maxRetries;
    private final Duration retryDelay;
    private final Executor executor;

    public static Builder builder() {
        return RaftProtocol.builder(null);
    }

    public static Builder builder(String group) {
        return new Builder(group);
    }

    protected RaftProtocol(String group, Duration minTimeout, Duration maxTimeout, ReadConsistency readConsistency, CommunicationStrategy communicationStrategy, Recovery recoveryStrategy, int maxRetries, Duration retryDelay, Executor executor) {
        this.group = group;
        this.minTimeout = minTimeout;
        this.maxTimeout = maxTimeout;
        this.readConsistency = readConsistency;
        this.communicationStrategy = communicationStrategy;
        this.recoveryStrategy = recoveryStrategy;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        this.executor = executor;
    }

    public PrimitiveProtocol.Type type() {
        return TYPE;
    }

    public String group() {
        return this.group;
    }

    public Duration minTimeout() {
        return this.minTimeout;
    }

    public Duration maxTimeout() {
        return this.maxTimeout;
    }

    public ReadConsistency readConsistency() {
        return this.readConsistency;
    }

    public CommunicationStrategy communicationStrategy() {
        return this.communicationStrategy;
    }

    public Recovery recoveryStrategy() {
        return this.recoveryStrategy;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public Duration retryDelay() {
        return this.retryDelay;
    }

    public Executor executor() {
        return this.executor;
    }

    public static class Builder
    extends PrimitiveProtocol.Builder<RaftProtocol> {
        private Duration minTimeout = Duration.ofMillis(250L);
        private Duration maxTimeout = Duration.ofSeconds(30L);
        private ReadConsistency readConsistency = ReadConsistency.SEQUENTIAL;
        private CommunicationStrategy communicationStrategy = CommunicationStrategy.LEADER;
        private Recovery recoveryStrategy = Recovery.RECOVER;
        private int maxRetries = 0;
        private Duration retryDelay = Duration.ofMillis(100L);
        private Executor executor;

        protected Builder(String group) {
            super(group);
        }

        public Builder withMinTimeout(Duration minTimeout) {
            this.minTimeout = (Duration)Preconditions.checkNotNull((Object)minTimeout, (Object)"minTimeout cannot be null");
            return this;
        }

        public Builder withMaxTimeout(Duration maxTimeout) {
            this.maxTimeout = (Duration)Preconditions.checkNotNull((Object)maxTimeout, (Object)"maxTimeout cannot be null");
            return this;
        }

        public Builder withReadConsistency(ReadConsistency readConsistency) {
            this.readConsistency = (ReadConsistency)((Object)Preconditions.checkNotNull((Object)((Object)readConsistency), (Object)"readConsistency cannot be null"));
            return this;
        }

        public Builder withCommunicationStrategy(CommunicationStrategy communicationStrategy) {
            this.communicationStrategy = (CommunicationStrategy)Preconditions.checkNotNull((Object)communicationStrategy, (Object)"communicationStrategy cannot be null");
            return this;
        }

        public Builder withRecoveryStrategy(Recovery recoveryStrategy) {
            this.recoveryStrategy = (Recovery)Preconditions.checkNotNull((Object)recoveryStrategy, (Object)"recoveryStrategy cannot be null");
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must be positive");
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withRetryDelayMillis(long retryDelayMillis) {
            return this.withRetryDelay(Duration.ofMillis(retryDelayMillis));
        }

        public Builder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
            return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
        }

        public Builder withRetryDelay(Duration retryDelay) {
            this.retryDelay = (Duration)Preconditions.checkNotNull((Object)retryDelay, (Object)"retryDelay cannot be null");
            return this;
        }

        public Builder withExecutor(Executor executor) {
            this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
            return this;
        }

        public RaftProtocol build() {
            return new RaftProtocol(this.group, this.minTimeout, this.maxTimeout, this.readConsistency, this.communicationStrategy, this.recoveryStrategy, this.maxRetries, this.retryDelay, this.executor);
        }
    }
}

