/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.cluster.NodeId;
import io.atomix.messaging.Endpoint;
import io.atomix.messaging.MessagingService;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.net.ConnectException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class RaftMessagingProtocol {
    protected final MessagingService messagingService;
    protected final Serializer serializer;
    private final Function<NodeId, Endpoint> endpointProvider;

    public RaftMessagingProtocol(MessagingService messagingService, Serializer serializer, Function<NodeId, Endpoint> endpointProvider) {
        this.messagingService = messagingService;
        this.serializer = serializer;
        this.endpointProvider = endpointProvider;
    }

    protected Endpoint endpoint(NodeId nodeId) {
        return this.endpointProvider.apply(nodeId);
    }

    protected <T, U> CompletableFuture<U> sendAndReceive(NodeId nodeId, String type, T request) {
        Endpoint endpoint = this.endpoint(nodeId);
        if (endpoint == null) {
            return Futures.exceptionalFuture((Throwable)new ConnectException());
        }
        return this.messagingService.sendAndReceive(endpoint, type, this.serializer.encode(request)).thenApply(arg_0 -> ((Serializer)this.serializer).decode(arg_0));
    }

    protected CompletableFuture<Void> sendAsync(NodeId nodeId, String type, Object request) {
        Endpoint endpoint = this.endpoint(nodeId);
        if (endpoint != null) {
            return this.messagingService.sendAsync(this.endpoint(nodeId), type, this.serializer.encode(request));
        }
        return CompletableFuture.completedFuture(null);
    }

    protected <T, U> void registerHandler(String type, Function<T, CompletableFuture<U>> handler) {
        this.messagingService.registerHandler(type, (e, p) -> {
            CompletableFuture future = new CompletableFuture();
            ((CompletableFuture)handler.apply(this.serializer.decode(p))).whenComplete((result, error) -> {
                if (error == null) {
                    future.complete(this.serializer.encode(result));
                } else {
                    future.completeExceptionally((Throwable)error);
                }
            });
            return future;
        });
    }

    protected void unregisterHandler(String type) {
        this.messagingService.unregisterHandler(type);
    }
}

