/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.collect.Maps;
import io.atomix.cluster.NodeId;
import io.atomix.messaging.Endpoint;
import io.atomix.messaging.MessagingService;
import io.atomix.messaging.impl.NettyMessagingService;
import io.atomix.primitive.DistributedPrimitiveBuilder;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.operation.impl.DefaultOperationId;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftPerformanceTest;
import io.atomix.protocols.raft.RaftProtocol;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.LocalRaftProtocolFactory;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientMessagingProtocol;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.RaftServerMessagingProtocol;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.protocols.raft.storage.log.entry.CloseSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.CommandEntry;
import io.atomix.protocols.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.protocols.raft.storage.log.entry.InitializeEntry;
import io.atomix.protocols.raft.storage.log.entry.KeepAliveEntry;
import io.atomix.protocols.raft.storage.log.entry.MetadataEntry;
import io.atomix.protocols.raft.storage.log.entry.OpenSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.system.Configuration;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.buffer.BufferInput;
import io.atomix.storage.buffer.BufferOutput;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.serializer.KryoNamespace;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class RaftFuzzTest
implements Runnable {
    private static final boolean USE_NETTY = true;
    private static final int ITERATIONS = 1000;
    private static final String CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final CommunicationStrategy COMMUNICATION_STRATEGY = CommunicationStrategy.ANY;
    private static final Serializer protocolSerializer = Serializer.using((Namespace)KryoNamespace.builder().register(new Class[]{OpenSessionRequest.class}).register(new Class[]{OpenSessionResponse.class}).register(new Class[]{CloseSessionRequest.class}).register(new Class[]{CloseSessionResponse.class}).register(new Class[]{KeepAliveRequest.class}).register(new Class[]{KeepAliveResponse.class}).register(new Class[]{QueryRequest.class}).register(new Class[]{QueryResponse.class}).register(new Class[]{CommandRequest.class}).register(new Class[]{CommandResponse.class}).register(new Class[]{MetadataRequest.class}).register(new Class[]{MetadataResponse.class}).register(new Class[]{JoinRequest.class}).register(new Class[]{JoinResponse.class}).register(new Class[]{LeaveRequest.class}).register(new Class[]{LeaveResponse.class}).register(new Class[]{ConfigureRequest.class}).register(new Class[]{ConfigureResponse.class}).register(new Class[]{ReconfigureRequest.class}).register(new Class[]{ReconfigureResponse.class}).register(new Class[]{InstallRequest.class}).register(new Class[]{InstallResponse.class}).register(new Class[]{PollRequest.class}).register(new Class[]{PollResponse.class}).register(new Class[]{VoteRequest.class}).register(new Class[]{VoteResponse.class}).register(new Class[]{AppendRequest.class}).register(new Class[]{AppendResponse.class}).register(new Class[]{PublishRequest.class}).register(new Class[]{ResetRequest.class}).register(new Class[]{RaftResponse.Status.class}).register(new Class[]{RaftError.class}).register(new Class[]{RaftError.Type.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{byte[].class}).register(new Class[]{long[].class}).register(new Class[]{CloseSessionEntry.class}).register(new Class[]{CommandEntry.class}).register(new Class[]{ConfigurationEntry.class}).register(new Class[]{InitializeEntry.class}).register(new Class[]{KeepAliveEntry.class}).register(new Class[]{MetadataEntry.class}).register(new Class[]{OpenSessionEntry.class}).register(new Class[]{QueryEntry.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{DefaultOperationId.class}).register(new Class[]{OperationType.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{ArrayList.class}).register(new Class[]{Collections.emptyList().getClass()}).register(new Class[]{HashSet.class}).register(new Class[]{DefaultRaftMember.class}).register(new Class[]{NodeId.class}).register(new Class[]{SessionId.class}).register(new Class[]{RaftMember.Type.class}).register(new Class[]{Instant.class}).register(new Class[]{Configuration.class}).build());
    private static final Serializer storageSerializer = Serializer.using((Namespace)KryoNamespace.builder().register(new Class[]{CloseSessionEntry.class}).register(new Class[]{CommandEntry.class}).register(new Class[]{ConfigurationEntry.class}).register(new Class[]{InitializeEntry.class}).register(new Class[]{KeepAliveEntry.class}).register(new Class[]{MetadataEntry.class}).register(new Class[]{OpenSessionEntry.class}).register(new Class[]{QueryEntry.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{DefaultOperationId.class}).register(new Class[]{OperationType.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{ArrayList.class}).register(new Class[]{HashSet.class}).register(new Class[]{DefaultRaftMember.class}).register(new Class[]{NodeId.class}).register(new Class[]{RaftMember.Type.class}).register(new Class[]{Instant.class}).register(new Class[]{Configuration.class}).register(new Class[]{byte[].class}).register(new Class[]{long[].class}).build());
    private static final Serializer clientSerializer = Serializer.using((Namespace)KryoNamespace.builder().register(new Class[]{ReadConsistency.class}).register(new Class[]{Maps.immutableEntry((Object)"", (Object)"").getClass()}).build());
    private int nextId;
    private int port = 5000;
    private List<RaftMember> members = new ArrayList<RaftMember>();
    private List<RaftClient> clients = new ArrayList<RaftClient>();
    private List<RaftServer> servers = new ArrayList<RaftServer>();
    private Map<Integer, Scheduled> shutdownTimers = new ConcurrentHashMap<Integer, Scheduled>();
    private Map<Integer, Scheduled> restartTimers = new ConcurrentHashMap<Integer, Scheduled>();
    private LocalRaftProtocolFactory protocolFactory;
    private List<MessagingService> messagingServices = new ArrayList<MessagingService>();
    private Map<NodeId, Endpoint> endpointMap = new ConcurrentHashMap<NodeId, Endpoint>();
    private static final String[] KEYS = new String[1024];
    private final Random random = new Random();
    private static final OperationId PUT;
    private static final OperationId GET;
    private static final OperationId REMOVE;
    private static final OperationId INDEX;

    public static void main(String[] args) {
        new RaftFuzzTest().run();
    }

    @Override
    public void run() {
        for (int i = 0; i < 1000; ++i) {
            try {
                this.runFuzzTest();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private String randomKey() {
        return KEYS[this.randomNumber(KEYS.length)];
    }

    private ReadConsistency randomConsistency() {
        return ReadConsistency.values()[this.randomNumber(ReadConsistency.values().length)];
    }

    private int randomNumber(int limit) {
        return this.random.nextInt(limit);
    }

    private boolean randomBoolean() {
        return this.randomNumber(2) == 1;
    }

    private String randomString(int maxLength) {
        int length = this.randomNumber(maxLength) + 1;
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(CHARS.charAt(this.random.nextInt(CHARS.length())));
        }
        return sb.toString();
    }

    private void runFuzzTest() throws Exception {
        this.reset();
        this.createServers(this.randomNumber(5) + 3);
        Object lock = new Object();
        AtomicLong index = new AtomicLong();
        HashMap indexes = new HashMap();
        SingleThreadContext context = new SingleThreadContext("fuzz-test");
        int clients = this.randomNumber(10) + 1;
        int i = 0;
        while (i < clients) {
            ReadConsistency consistency = this.randomConsistency();
            RaftClient client = this.createClient();
            PrimitiveProxy proxy = this.createProxy(client, consistency);
            SingleThreadContext scheduler = new SingleThreadContext("fuzz-test-" + i);
            int clientId = i++;
            scheduler.schedule(Duration.ofMillis(100 * clients + (this.randomNumber(50) - 25)), Duration.ofMillis(100 * clients + (this.randomNumber(50) - 25)), () -> {
                long lastLinearizableIndex = index.get();
                int type = this.randomNumber(4);
                switch (type) {
                    case 0: {
                        proxy.invoke(PUT, arg_0 -> ((Serializer)clientSerializer).encode(arg_0), (Object)Maps.immutableEntry((Object)this.randomKey(), (Object)this.randomString(16384)), arg_0 -> ((Serializer)clientSerializer).decode(arg_0)).thenAccept(result -> {
                            Object object = lock;
                            synchronized (object) {
                                if (result < lastLinearizableIndex) {
                                    System.out.println(result + " is less than last linearizable index " + lastLinearizableIndex);
                                    System.exit(1);
                                } else if (result > index.get()) {
                                    index.set((long)result);
                                }
                                Long lastSequentialIndex = (Long)indexes.get(clientId);
                                if (lastSequentialIndex == null) {
                                    indexes.put(clientId, result);
                                } else if (result < lastSequentialIndex) {
                                    System.out.println(result + " is less than last sequential index " + lastSequentialIndex);
                                    System.exit(1);
                                } else {
                                    indexes.put(clientId, lastSequentialIndex);
                                }
                            }
                        });
                        break;
                    }
                    case 1: {
                        proxy.invoke(GET, arg_0 -> ((Serializer)clientSerializer).encode(arg_0), (Object)this.randomKey(), arg_0 -> ((Serializer)clientSerializer).decode(arg_0));
                        break;
                    }
                    case 2: {
                        proxy.invoke(REMOVE, arg_0 -> ((Serializer)clientSerializer).encode(arg_0), (Object)this.randomKey(), arg_0 -> ((Serializer)clientSerializer).decode(arg_0)).thenAccept(result -> {
                            Object object = lock;
                            synchronized (object) {
                                if (result < lastLinearizableIndex) {
                                    System.out.println(result + " is less than last linearizable index " + lastLinearizableIndex);
                                    System.exit(1);
                                } else if (result > index.get()) {
                                    index.set((long)result);
                                }
                                Long lastSequentialIndex = (Long)indexes.get(clientId);
                                if (lastSequentialIndex == null) {
                                    indexes.put(clientId, result);
                                } else if (result < lastSequentialIndex) {
                                    System.out.println(result + " is less than last sequential index " + lastSequentialIndex);
                                    System.exit(1);
                                } else {
                                    indexes.put(clientId, lastSequentialIndex);
                                }
                            }
                        });
                        break;
                    }
                    case 3: {
                        proxy.invoke(INDEX, arg_0 -> ((Serializer)clientSerializer).decode(arg_0)).thenAccept(arg_0 -> RaftFuzzTest.lambda$null$2(lock, consistency, lastLinearizableIndex, index, indexes, clientId, arg_0));
                    }
                }
            });
        }
        this.scheduleRestarts((ThreadContext)context);
        Thread.sleep(Duration.ofMinutes(15L).toMillis());
    }

    private void scheduleRestarts(ThreadContext context) {
        if (this.shutdownTimers.isEmpty() && this.restartTimers.isEmpty()) {
            int shutdownCount = this.randomNumber(this.servers.size() - 2) + 1;
            boolean remove = this.randomBoolean();
            for (int i = 0; i < shutdownCount; ++i) {
                this.scheduleRestart(remove, i, context);
            }
        }
    }

    private void scheduleRestart(boolean remove, int serverIndex, ThreadContext context) {
        this.shutdownTimers.put(serverIndex, context.schedule(Duration.ofSeconds(this.randomNumber(120) + 10), () -> {
            CompletableFuture<Void> leaveFuture;
            this.shutdownTimers.remove(serverIndex);
            RaftServer server = this.servers.get(serverIndex);
            if (remove) {
                System.out.println("Removing server: " + server.cluster().getMember().nodeId());
                leaveFuture = server.leave();
            } else {
                System.out.println("Shutting down server: " + server.cluster().getMember().nodeId());
                leaveFuture = server.shutdown();
            }
            leaveFuture.whenComplete((result, error) -> this.restartTimers.put(serverIndex, context.schedule(Duration.ofSeconds(this.randomNumber(120) + 10), () -> {
                CompletableFuture<RaftServer> joinFuture;
                this.restartTimers.remove(serverIndex);
                RaftServer newServer = this.createServer(server.cluster().getMember());
                this.servers.set(serverIndex, newServer);
                if (remove) {
                    System.out.println("Adding server: " + newServer.cluster().getMember().nodeId());
                    joinFuture = newServer.join(this.members.get(this.members.size() - 1).nodeId());
                } else {
                    System.out.println("Bootstrapping server: " + newServer.cluster().getMember().nodeId());
                    joinFuture = newServer.bootstrap(this.members.stream().map(RaftMember::nodeId).collect(Collectors.toList()));
                }
                joinFuture.whenComplete((result2, error2) -> this.scheduleRestarts(context));
            })));
        }));
    }

    private void reset() throws Exception {
        for (Scheduled shutdownTimer : this.shutdownTimers.values()) {
            shutdownTimer.cancel();
        }
        this.shutdownTimers.clear();
        for (Scheduled restartTimer : this.restartTimers.values()) {
            restartTimer.cancel();
        }
        this.restartTimers.clear();
        this.clients.forEach(c -> {
            try {
                c.close().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.servers.forEach(s -> {
            try {
                if (s.isRunning()) {
                    s.shutdown().get(10L, TimeUnit.SECONDS);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Path directory = Paths.get("target/fuzz-logs/", new String[0]);
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        this.members = new ArrayList<RaftMember>();
        this.port = 5000;
        this.clients = new ArrayList<RaftClient>();
        this.servers = new ArrayList<RaftServer>();
        this.protocolFactory = new LocalRaftProtocolFactory(protocolSerializer);
    }

    private NodeId nextNodeId() {
        return NodeId.from((String)String.valueOf(++this.nextId));
    }

    private RaftMember nextMember(RaftMember.Type type) {
        return new TestMember(this.nextNodeId(), type);
    }

    private List<RaftServer> createServers(int nodes) throws Exception {
        ArrayList<RaftServer> servers = new ArrayList<RaftServer>();
        for (int i = 0; i < nodes; ++i) {
            this.members.add(this.nextMember(RaftMember.Type.ACTIVE));
        }
        CountDownLatch latch = new CountDownLatch(nodes);
        for (int i = 0; i < nodes; ++i) {
            RaftServer server = this.createServer(this.members.get(i));
            server.bootstrap(this.members.stream().map(RaftMember::nodeId).collect(Collectors.toList())).thenRun(latch::countDown);
            servers.add(server);
        }
        latch.await(30000L, TimeUnit.MILLISECONDS);
        return servers;
    }

    private RaftServer createServer(RaftMember member) {
        RaftServerMessagingProtocol protocol;
        try {
            Endpoint endpoint = new Endpoint(InetAddress.getLocalHost(), ++this.port);
            MessagingService messagingManager = (MessagingService)NettyMessagingService.builder().withEndpoint(endpoint).build().start().join();
            this.messagingServices.add(messagingManager);
            this.endpointMap.put(member.nodeId(), endpoint);
            protocol = new RaftServerMessagingProtocol(messagingManager, protocolSerializer, this.endpointMap::get);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        RaftServer.Builder builder = RaftServer.builder(member.nodeId()).withProtocol(protocol).withStorage(RaftStorage.builder().withStorageLevel(StorageLevel.DISK).withDirectory(new File(String.format("target/fuzz-logs/%s", member.nodeId()))).withSerializer(storageSerializer).withMaxSegmentSize(0x100000).build()).addPrimitiveType(TestPrimitiveType.INSTANCE);
        RaftServer server = (RaftServer)builder.build();
        this.servers.add(server);
        return server;
    }

    private RaftClient createClient() throws Exception {
        NodeId nodeId = this.nextNodeId();
        Endpoint endpoint = new Endpoint(InetAddress.getLocalHost(), ++this.port);
        MessagingService messagingManager = (MessagingService)NettyMessagingService.builder().withEndpoint(endpoint).build().start().join();
        this.endpointMap.put(nodeId, endpoint);
        RaftClientMessagingProtocol protocol = new RaftClientMessagingProtocol(messagingManager, protocolSerializer, this.endpointMap::get);
        RaftClient client = (RaftClient)RaftClient.builder().withNodeId(nodeId).withProtocol(protocol).build();
        client.connect(this.members.stream().map(RaftMember::nodeId).collect(Collectors.toList())).join();
        this.clients.add(client);
        return client;
    }

    private PrimitiveProxy createProxy(RaftClient client, ReadConsistency consistency) {
        return (PrimitiveProxy)client.newProxy("test", TestPrimitiveType.INSTANCE, RaftProtocol.builder().withReadConsistency(consistency).withCommunicationStrategy(COMMUNICATION_STRATEGY).build()).connect().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$null$2(Object lock, ReadConsistency consistency, long lastLinearizableIndex, AtomicLong index, Map indexes, int clientId, Long result) {
        var8_7 = lock;
        synchronized (var8_7) {
            switch (2.$SwitchMap$io$atomix$protocols$raft$ReadConsistency[consistency.ordinal()]) {
                case 1: 
                case 2: {
                    if (result >= lastLinearizableIndex) ** GOTO lbl10
                    System.out.println(result + " is less than last linearizable index " + lastLinearizableIndex);
                    System.exit(1);
                    ** GOTO lbl12
lbl10:
                    // 1 sources

                    if (result > index.get()) {
                        index.set(result);
                    }
                }
lbl12:
                // 5 sources

                case 3: {
                    lastSequentialIndex = (Long)indexes.get(clientId);
                    if (lastSequentialIndex == null) {
                        indexes.put(clientId, result);
                        break;
                    }
                    if (result < lastSequentialIndex) {
                        System.out.println(result + " is less than last sequential index " + lastSequentialIndex);
                        System.exit(1);
                        break;
                    }
                    indexes.put(clientId, lastSequentialIndex);
                }
            }
        }
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            RaftFuzzTest.KEYS[i] = UUID.randomUUID().toString();
        }
        PUT = OperationId.command((String)"put");
        GET = OperationId.query((String)"get");
        REMOVE = OperationId.command((String)"remove");
        INDEX = OperationId.command((String)"index");
    }

    public static class TestMember
    implements RaftMember {
        private final NodeId nodeId;
        private final RaftMember.Type type;

        public TestMember(NodeId nodeId, RaftMember.Type type) {
            this.nodeId = nodeId;
            this.type = type;
        }

        public NodeId nodeId() {
            return this.nodeId;
        }

        public int hash() {
            return this.nodeId.hashCode();
        }

        public RaftMember.Type getType() {
            return this.type;
        }

        public void addTypeChangeListener(Consumer<RaftMember.Type> listener) {
        }

        public void removeTypeChangeListener(Consumer<RaftMember.Type> listener) {
        }

        public Instant getLastUpdated() {
            return Instant.now();
        }

        public CompletableFuture<Void> promote() {
            return null;
        }

        public CompletableFuture<Void> promote(RaftMember.Type type) {
            return null;
        }

        public CompletableFuture<Void> demote() {
            return null;
        }

        public CompletableFuture<Void> demote(RaftMember.Type type) {
            return null;
        }

        public CompletableFuture<Void> remove() {
            return null;
        }
    }

    public static class FuzzStateMachine
    extends AbstractPrimitiveService {
        private Map<String, String> map = new HashMap<String, String>();

        protected void configure(ServiceExecutor executor) {
            executor.register(PUT, arg_0 -> ((Serializer)clientSerializer).decode(arg_0), this::put, arg_0 -> ((Serializer)clientSerializer).encode(arg_0));
            executor.register(GET, arg_0 -> ((Serializer)clientSerializer).decode(arg_0), this::get, arg_0 -> ((Serializer)clientSerializer).encode(arg_0));
            executor.register(REMOVE, arg_0 -> ((Serializer)clientSerializer).decode(arg_0), this::remove, arg_0 -> ((Serializer)clientSerializer).encode(arg_0));
            executor.register(INDEX, this::index, arg_0 -> ((Serializer)clientSerializer).encode(arg_0));
        }

        public void backup(BufferOutput<?> writer) {
            writer.writeInt(this.map.size());
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                writer.writeString(entry.getKey());
                writer.writeString(entry.getValue());
            }
        }

        public void restore(BufferInput<?> reader) {
            this.map = new HashMap<String, String>();
            int size = reader.readInt();
            for (int i = 0; i < size; ++i) {
                String key = reader.readString();
                String value = reader.readString();
                this.map.put(key, value);
            }
        }

        protected long put(Commit<Map.Entry<String, String>> commit) {
            this.map.put((String)((Map.Entry)commit.value()).getKey(), (String)((Map.Entry)commit.value()).getValue());
            return commit.index();
        }

        protected String get(Commit<String> commit) {
            return this.map.get(commit.value());
        }

        protected long remove(Commit<String> commit) {
            this.map.remove(commit.value());
            return commit.index();
        }

        protected long index(Commit<Void> commit) {
            return commit.index();
        }
    }

    private static class TestPrimitiveType
    implements PrimitiveType {
        static final TestPrimitiveType INSTANCE = new TestPrimitiveType();

        private TestPrimitiveType() {
        }

        public String id() {
            return "test";
        }

        public PrimitiveService newService() {
            return new RaftPerformanceTest.PerformanceService();
        }

        public DistributedPrimitiveBuilder newPrimitiveBuilder(String name, PrimitiveManagementService managementService) {
            throw new UnsupportedOperationException();
        }
    }
}

