/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.protocol.SessionRequest;

public abstract class OperationRequest
extends SessionRequest {
    protected final long sequence;
    protected final RaftOperation operation;

    protected OperationRequest(long session, long sequence, RaftOperation operation) {
        super(session);
        this.sequence = sequence;
        this.operation = operation;
    }

    public long sequenceNumber() {
        return this.sequence;
    }

    public RaftOperation operation() {
        return this.operation;
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends OperationRequest>
    extends SessionRequest.Builder<T, U> {
        protected long sequence;
        protected RaftOperation operation;

        public T withSequence(long sequence) {
            Preconditions.checkArgument((sequence >= 0L ? 1 : 0) != 0, (Object)"sequence must be positive");
            this.sequence = sequence;
            return (T)this;
        }

        public T withOperation(RaftOperation operation) {
            this.operation = (RaftOperation)Preconditions.checkNotNull((Object)operation, (Object)"operation cannot be null");
            return (T)this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.sequence >= 0L ? 1 : 0) != 0, (Object)"sequence must be positive");
            Preconditions.checkNotNull((Object)this.operation, (Object)"operation cannot be null");
        }
    }
}

