/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.protocol.AbstractRaftResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import java.util.Collection;
import java.util.Objects;

public abstract class ConfigurationResponse
extends AbstractRaftResponse {
    protected final long index;
    protected final long term;
    protected final long timestamp;
    protected final Collection<RaftMember> members;

    public ConfigurationResponse(RaftResponse.Status status, RaftError error, long index, long term, long timestamp, Collection<RaftMember> members) {
        super(status, error);
        this.index = index;
        this.term = term;
        this.timestamp = timestamp;
        this.members = members;
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Collection<RaftMember> members() {
        return this.members;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.index, this.term, this.members});
    }

    @Override
    public boolean equals(Object object) {
        if (this.getClass().isAssignableFrom(object.getClass())) {
            ConfigurationResponse response = (ConfigurationResponse)object;
            return response.status == this.status && response.index == this.index && response.term == this.term && response.timestamp == this.timestamp && response.members.equals(this.members);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("index", this.index).add("term", this.term).add("timestamp", this.timestamp).add("members", this.members).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends ConfigurationResponse>
    extends AbstractRaftResponse.Builder<T, U> {
        protected long index;
        protected long term;
        protected long timestamp;
        protected Collection<RaftMember> members;

        public T withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return (T)this;
        }

        public T withTerm(long term) {
            Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return (T)this;
        }

        public T withTime(long time) {
            Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (Object)"time must be positive");
            this.timestamp = time;
            return (T)this;
        }

        public T withMembers(Collection<RaftMember> members) {
            this.members = (Collection)Preconditions.checkNotNull(members, (Object)"members cannot be null");
            return (T)this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
                Preconditions.checkArgument((this.term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
                Preconditions.checkArgument((this.timestamp > 0L ? 1 : 0) != 0, (Object)"time must be positive");
                Preconditions.checkNotNull(this.members, (Object)"members cannot be null");
            }
        }
    }
}

