/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.messaging.Endpoint;
import io.atomix.messaging.MessagingService;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftMessagingProtocol;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.serializer.Serializer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class RaftClientMessagingProtocol
extends RaftMessagingProtocol
implements RaftClientProtocol {
    public RaftClientMessagingProtocol(MessagingService messagingService, Serializer serializer, Function<MemberId, Endpoint> endpointProvider) {
        super(messagingService, serializer, endpointProvider);
    }

    @Override
    public CompletableFuture<OpenSessionResponse> openSession(MemberId memberId, OpenSessionRequest request) {
        return this.sendAndReceive(memberId, "open-session", request);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> closeSession(MemberId memberId, CloseSessionRequest request) {
        return this.sendAndReceive(memberId, "close-session", request);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(MemberId memberId, KeepAliveRequest request) {
        return this.sendAndReceive(memberId, "keep-alive", request);
    }

    @Override
    public CompletableFuture<QueryResponse> query(MemberId memberId, QueryRequest request) {
        return this.sendAndReceive(memberId, "query", request);
    }

    @Override
    public CompletableFuture<CommandResponse> command(MemberId memberId, CommandRequest request) {
        return this.sendAndReceive(memberId, "command", request);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(MemberId memberId, MetadataRequest request) {
        return this.sendAndReceive(memberId, "metadata", request);
    }

    @Override
    public void reset(Collection<MemberId> members, ResetRequest request) {
        for (MemberId memberId : members) {
            this.sendAsync(memberId, String.format("reset-%d", request.session()), request);
        }
    }

    @Override
    public void registerPublishListener(SessionId sessionId, Consumer<PublishRequest> listener, Executor executor) {
        this.messagingService.registerHandler(String.format("publish-%d", sessionId.id()), (e, p) -> listener.accept((PublishRequest)this.serializer.decode(p)), executor);
    }

    @Override
    public void unregisterPublishListener(SessionId sessionId) {
        this.messagingService.unregisterHandler(String.format("publish-%d", sessionId.id()));
    }
}

