/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.MoreObjects;
import io.atomix.storage.journal.Indexed;
import java.util.HashMap;
import java.util.Map;

class JournalSegmentCache {
    private final int size;
    private final Map<Long, Indexed> entries;
    private long firstIndex;
    private long lastIndex;

    JournalSegmentCache(long index, int size) {
        this.size = size;
        this.entries = new HashMap<Long, Indexed>(size);
        this.firstIndex = index;
    }

    public long index() {
        return this.lastIndex;
    }

    public void put(Indexed indexed) {
        if (indexed.index() == this.firstIndex + (long)this.entries.size()) {
            this.entries.put(indexed.index(), indexed);
            this.lastIndex = indexed.index();
        }
        if (this.entries.size() > this.size) {
            this.entries.remove(this.firstIndex);
            ++this.firstIndex;
        }
    }

    public Indexed get(long index) {
        return this.entries.get(index);
    }

    public void truncate(long index) {
        if (index < this.firstIndex) {
            this.firstIndex = index + 1L;
            this.lastIndex = 0L;
            this.entries.clear();
        } else {
            int size = this.entries.size();
            for (long i = index + 1L; i < this.firstIndex + (long)size; ++i) {
                this.entries.remove(i);
            }
            this.lastIndex = this.firstIndex + (long)this.entries.size() - 1L;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.size).toString();
    }
}

