/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalSegmentReader;
import io.atomix.storage.journal.SegmentedJournal;
import java.util.NoSuchElementException;

public class SegmentedJournalReader<E>
implements JournalReader<E> {
    private final SegmentedJournal<E> journal;
    private JournalSegment<E> currentSegment;
    private Indexed<E> previousEntry;
    private JournalSegmentReader<E> currentReader;

    public SegmentedJournalReader(SegmentedJournal<E> journal, long index) {
        this.journal = journal;
        this.initialize(index);
    }

    private void initialize(long index) {
        this.currentSegment = this.journal.getSegment(index);
        this.currentReader = this.currentSegment.createReader();
        long nextIndex = this.getNextIndex();
        while (index > nextIndex && this.hasNext()) {
            this.next();
            nextIndex = this.getNextIndex();
        }
    }

    public long getFirstIndex() {
        return this.journal.getFirstSegment().index();
    }

    @Override
    public long getCurrentIndex() {
        long currentIndex = this.currentReader.getCurrentIndex();
        if (currentIndex != 0L) {
            return currentIndex;
        }
        if (this.previousEntry != null) {
            return this.previousEntry.index();
        }
        return 0L;
    }

    @Override
    public Indexed<E> getCurrentEntry() {
        Indexed<E> currentEntry = this.currentReader.getCurrentEntry();
        if (currentEntry != null) {
            return currentEntry;
        }
        return this.previousEntry;
    }

    @Override
    public long getNextIndex() {
        return this.currentReader.getNextIndex();
    }

    @Override
    public void reset() {
        this.currentReader.close();
        this.currentSegment = this.journal.getFirstSegment();
        this.currentReader = this.currentSegment.createReader();
        this.previousEntry = null;
    }

    @Override
    public void reset(long index) {
        if (!this.currentSegment.isOpen()) {
            this.reset();
        }
        if (index < this.currentReader.getNextIndex()) {
            this.rewind(index);
        } else if (index > this.currentReader.getNextIndex()) {
            this.forward(index);
        }
    }

    private void rewind(long index) {
        JournalSegment<E> segment;
        if (this.currentSegment.index() >= index && (segment = this.journal.getSegment(index - 1L)) != null) {
            this.currentReader.close();
            this.currentSegment = segment;
            this.currentReader = this.currentSegment.createReader();
        }
        this.currentReader.reset(index);
        this.previousEntry = this.currentReader.getCurrentEntry();
    }

    private void forward(long index) {
        while (this.getNextIndex() < index && this.hasNext()) {
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.currentReader.hasNext()) {
            JournalSegment<E> nextSegment = this.journal.getNextSegment(this.currentSegment.index());
            if (nextSegment != null) {
                this.previousEntry = this.currentReader.getCurrentEntry();
                this.currentSegment = nextSegment;
                this.currentReader = this.currentSegment.createReader();
                return this.currentReader.hasNext();
            }
            return false;
        }
        return true;
    }

    @Override
    public Indexed<E> next() {
        if (!this.currentReader.hasNext()) {
            JournalSegment<E> nextSegment = this.journal.getNextSegment(this.currentSegment.index());
            if (nextSegment != null) {
                this.previousEntry = this.currentReader.getCurrentEntry();
                this.currentSegment = nextSegment;
                this.currentReader = this.currentSegment.createReader();
                return this.currentReader.next();
            }
            throw new NoSuchElementException();
        }
        this.previousEntry = this.currentReader.getCurrentEntry();
        return this.currentReader.next();
    }

    @Override
    public void close() {
        this.currentReader.close();
        this.journal.closeReader(this);
    }
}

