/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import com.google.common.collect.Maps;
import io.atomix.core.tree.AsyncAtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTreeConfig;
import io.atomix.core.tree.AtomicDocumentTreeType;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.IllegalDocumentModificationException;
import io.atomix.core.tree.NoSuchDocumentPathException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.rest.AtomixResource;
import io.atomix.rest.resources.PrimitiveResource;
import io.atomix.utils.time.Versioned;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtomixResource
@Path(value="/atomic-document-tree")
public class DocumentTreeResource
extends PrimitiveResource<AsyncAtomicDocumentTree<String>, AtomicDocumentTreeConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentTreeResource.class);

    public DocumentTreeResource() {
        super((PrimitiveType)AtomicDocumentTreeType.instance());
    }

    private DocumentPath getDocumentPath(List<PathSegment> params) {
        if (params.isEmpty()) {
            return DocumentPath.ROOT;
        }
        return DocumentPath.from(params.stream().map(PathSegment::getPath).collect(Collectors.toList()));
    }

    @GET
    @Path(value="/{name}/{path: .*}")
    @Produces(value={"application/json"})
    public void get(@PathParam(value="name") String name, @PathParam(value="path") List<PathSegment> path, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(tree -> tree.get(this.getDocumentPath(path)))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new VersionedResult((Versioned<String>)result)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/{path: .*}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public void create(@PathParam(value="name") String name, @PathParam(value="path") List<PathSegment> path, String value, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(tree -> tree.createRecursive(this.getDocumentPath(path), (Object)value))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @PUT
    @Path(value="/{name}/{path: .*}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public void set(@PathParam(value="name") String name, @PathParam(value="path") List<PathSegment> path, String value, @QueryParam(value="version") Long version, @Suspended AsyncResponse response) {
        CompletionStage future = version != null ? this.getPrimitive(name).thenCompose(tree -> tree.replace(this.getDocumentPath(path), (Object)value, version.longValue())) : this.getPrimitive(name).thenCompose(tree -> tree.set(this.getDocumentPath(path), (Object)value).thenApply(v -> Boolean.TRUE));
        ((CompletableFuture)future).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                if (error.getCause() != null) {
                    error = error.getCause();
                }
                if (error instanceof IllegalDocumentModificationException || error instanceof NoSuchDocumentPathException) {
                    response.resume((Object)Response.ok((Object)false).build());
                } else {
                    LOGGER.warn("{}", error);
                    response.resume((Object)Response.serverError().build());
                }
            }
        });
    }

    @GET
    @Path(value="/{name}/children")
    @Produces(value={"application/json"})
    public void getRootChildren(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(tree -> tree.getChildren(tree.root()))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)Maps.transformValues((Map)result, VersionedResult::new)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{name}/children/{path: .*}")
    @Produces(value={"application/json"})
    public void getChildren(@PathParam(value="name") String name, @PathParam(value="path") List<PathSegment> path, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(tree -> tree.getChildren(this.getDocumentPath(path)))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)Maps.transformValues((Map)result, VersionedResult::new)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{name}/{path: .*}")
    @Produces(value={"application/json"})
    public void removeNode(@PathParam(value="name") String name, @PathParam(value="path") List<PathSegment> path, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(tree -> tree.remove(this.getDocumentPath(path)))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new VersionedResult((Versioned<String>)result)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    static class VersionedResult {
        private final Versioned<String> value;

        VersionedResult(Versioned<String> value) {
            this.value = value;
        }

        public String getValue() {
            return (String)this.value.value();
        }

        public long getVersion() {
            return this.value.version();
        }
    }
}

