/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.lock.AsyncDistributedLock;
import io.atomix.core.lock.DistributedLockConfig;
import io.atomix.core.lock.DistributedLockType;
import io.atomix.primitive.PrimitiveType;
import io.atomix.rest.AtomixResource;
import io.atomix.rest.resources.PrimitiveResource;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtomixResource
@Path(value="/lock")
public class DistributedLockResource
extends PrimitiveResource<AsyncDistributedLock, DistributedLockConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLockResource.class);

    public DistributedLockResource() {
        super((PrimitiveType)DistributedLockType.instance());
    }

    @POST
    @Path(value="/{name}/lock")
    @Produces(value={"application/json"})
    public void lock(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(lock -> lock.lock())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{name}/lock")
    public void unlock(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(lock -> lock.unlock())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

