/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import io.atomix.core.PrimitivesService;
import io.atomix.primitive.AsyncPrimitive;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class PrimitiveCache {
    private final PrimitivesService primitives;
    private final Cache<String, AsyncPrimitive> cache;

    public PrimitiveCache(PrimitivesService primitives, int cacheSize) {
        this.primitives = primitives;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).removalListener(this::closePrimitive).build();
    }

    public <T extends AsyncPrimitive> T getPrimitive(String name, Function<PrimitivesService, T> factory) {
        try {
            return (T)((AsyncPrimitive)this.cache.get((Object)name, () -> (AsyncPrimitive)factory.apply(this.primitives)));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void closePrimitive(RemovalNotification<String, ? extends AsyncPrimitive> notification) {
        ((AsyncPrimitive)notification.getValue()).close();
    }
}

