/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.utils;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;

class EventSession<T> {
    private final Queue<T> events = new ConcurrentLinkedQueue<T>();
    private final Queue<CompletableFuture<T>> futures = new ConcurrentLinkedQueue<CompletableFuture<T>>();

    EventSession() {
    }

    void addEvent(T event) {
        CompletableFuture<T> future = this.futures.poll();
        if (future != null) {
            future.complete(event);
        } else {
            this.events.add(event);
            if (this.events.size() > 100) {
                this.events.remove();
            }
        }
    }

    CompletableFuture<T> nextEvent() {
        T event = this.events.poll();
        if (event != null) {
            return CompletableFuture.completedFuture(event);
        }
        CompletableFuture future = new CompletableFuture();
        this.futures.add(future);
        return future;
    }

    void close() {
        this.futures.forEach(future -> future.completeExceptionally(new IllegalStateException("Closed session")));
    }
}

