/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.PendingCommand;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.TransferRequest;
import io.atomix.protocols.raft.protocol.TransferResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.ActiveRole;
import io.atomix.protocols.raft.roles.LeaderAppender;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.storage.log.entry.CloseSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.CommandEntry;
import io.atomix.protocols.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.protocols.raft.storage.log.entry.InitializeEntry;
import io.atomix.protocols.raft.storage.log.entry.KeepAliveEntry;
import io.atomix.protocols.raft.storage.log.entry.MetadataEntry;
import io.atomix.protocols.raft.storage.log.entry.OpenSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.storage.system.Configuration;
import io.atomix.storage.StorageException;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.event.EventListener;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public final class LeaderRole
extends ActiveRole {
    private static final int MAX_PENDING_COMMANDS = 1000;
    private static final int MAX_APPEND_ATTEMPTS = 5;
    private final ClusterMembershipEventListener clusterListener = this::handleClusterEvent;
    private final LeaderAppender appender;
    private Scheduled appendTimer;
    private final Set<SessionId> expiring = Sets.newHashSet();
    private long configuring;
    private boolean transferring;

    public LeaderRole(RaftContext context) {
        super(context);
        this.appender = new LeaderAppender(this);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.LEADER;
    }

    @Override
    public synchronized CompletableFuture<RaftRole> start() {
        this.takeLeadership();
        this.appendInitialEntries().join();
        this.commitInitialEntries();
        this.raft.getMembershipService().addListener((EventListener)this.clusterListener);
        return ((CompletableFuture)super.start().thenRun(this::startAppendTimer)).thenApply(v -> this);
    }

    private void takeLeadership() {
        this.raft.setLeader(this.raft.getCluster().getMember().memberId());
        this.raft.getCluster().getRemoteMemberStates().forEach(m -> m.resetState(this.raft.getLog()));
    }

    private CompletableFuture<Void> appendInitialEntries() {
        long term = this.raft.getTerm();
        return this.appendAndCompact(new InitializeEntry(term, this.appender.getTime())).thenApply(index -> null);
    }

    private CompletableFuture<Void> commitInitialEntries() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.appender.appendEntries(this.appender.getIndex()).whenComplete((resultIndex, error) -> {
            this.raft.checkThread();
            if (this.isRunning()) {
                if (error == null) {
                    this.raft.getServiceManager().apply((long)resultIndex);
                    future.complete(null);
                } else {
                    this.raft.setLeader(null);
                    this.raft.transition(RaftServer.Role.FOLLOWER);
                }
            }
        });
        return future;
    }

    private void startAppendTimer() {
        this.log.trace("Starting append timer");
        this.appendTimer = this.raft.getThreadContext().schedule(Duration.ZERO, this.raft.getHeartbeatInterval(), this::appendMembers);
    }

    private void appendMembers() {
        this.raft.checkThread();
        if (this.isRunning()) {
            this.appender.appendEntries();
        }
    }

    private void handleClusterEvent(ClusterMembershipEvent event) {
        this.raft.getThreadContext().execute(() -> {
            if (event.type() == ClusterMembershipEvent.Type.MEMBER_REMOVED) {
                this.log.debug("Node {} deactivated", (Object)((Member)event.subject()).id());
                this.raft.getSessions().getSessions().stream().filter(session -> session.memberId().equals((Object)((Member)event.subject()).id())).forEach(this::expireSession);
            }
        });
    }

    private void expireSession(RaftSession session) {
        if (this.expiring.add(session.sessionId())) {
            this.log.debug("Expiring session due to heartbeat failure: {}", (Object)session);
            this.appendAndCompact(new CloseSessionEntry(this.raft.getTerm(), System.currentTimeMillis(), (Long)session.sessionId().id(), true, false)).whenCompleteAsync((entry, error) -> {
                if (error != null) {
                    this.expiring.remove(session.sessionId());
                    return;
                }
                this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
                    this.raft.checkThread();
                    if (this.isRunning()) {
                        if (commitError == null) {
                            this.raft.getServiceManager().apply(entry.index()).whenCompleteAsync((r, e) -> this.expiring.remove(session.sessionId()), (Executor)this.raft.getThreadContext());
                        } else {
                            this.expiring.remove(session.sessionId());
                        }
                    }
                });
            }, (Executor)this.raft.getThreadContext());
        }
    }

    private boolean configuring() {
        return this.configuring > 0L;
    }

    private boolean initializing() {
        return this.appender.getIndex() == 0L || this.raft.getCommitIndex() < this.appender.getIndex();
    }

    protected CompletableFuture<Long> configure(Collection<RaftMember> members) {
        this.raft.checkThread();
        long term = this.raft.getTerm();
        return this.appendAndCompact(new ConfigurationEntry(term, System.currentTimeMillis(), members)).thenComposeAsync(entry -> {
            this.configuring = entry.index();
            this.raft.getCluster().configure(new Configuration(entry.index(), ((ConfigurationEntry)entry.entry()).term(), ((ConfigurationEntry)entry.entry()).timestamp(), ((ConfigurationEntry)entry.entry()).members()));
            return this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
                this.raft.checkThread();
                if (this.isRunning() && commitError == null) {
                    this.raft.getServiceManager().apply(entry.index());
                }
                this.configuring = 0L;
            });
        }, (Executor)this.raft.getThreadContext());
    }

    @Override
    public CompletableFuture<JoinResponse> onJoin(JoinRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)JoinResponse.builder().withStatus(RaftResponse.Status.ERROR)).build()));
        }
        if (this.raft.getCluster().getMember(request.member().memberId()) != null) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(RaftResponse.Status.OK)).withIndex(this.raft.getCluster().getConfiguration().index())).withTerm(this.raft.getCluster().getConfiguration().term())).withTime(this.raft.getCluster().getConfiguration().time())).withMembers(this.raft.getCluster().getMembers())).build()));
        }
        RaftMember member = request.member();
        Collection<RaftMember> members = this.raft.getCluster().getMembers();
        members.add(new DefaultRaftMember(member.memberId(), member.getType(), Instant.now()));
        CompletableFuture<JoinResponse> future = new CompletableFuture<JoinResponse>();
        this.configure(members).whenComplete((index, error) -> {
            if (error == null) {
                future.complete(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(RaftResponse.Status.OK)).withIndex((long)index)).withTerm(this.raft.getCluster().getConfiguration().term())).withTime(this.raft.getCluster().getConfiguration().time())).withMembers(members)).build()));
            } else {
                future.complete(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).build()));
        }
        DefaultRaftMember existingMember = this.raft.getCluster().getMember(request.member().memberId());
        if (existingMember == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNKNOWN_SESSION)).build()));
        }
        if (request.index() > 0L && request.index() < this.raft.getCluster().getConfiguration().index() || request.term() != this.raft.getCluster().getConfiguration().term()) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.CONFIGURATION_ERROR)).build()));
        }
        if (existingMember.getType() == request.member().getType()) {
            Configuration configuration = this.raft.getCluster().getConfiguration();
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.OK)).withIndex(configuration.index())).withTerm(this.raft.getCluster().getConfiguration().term())).withTime(this.raft.getCluster().getConfiguration().time())).withMembers(configuration.members())).build()));
        }
        existingMember.update(request.member().getType(), Instant.now());
        Collection<RaftMember> members = this.raft.getCluster().getMembers();
        CompletableFuture<ReconfigureResponse> future = new CompletableFuture<ReconfigureResponse>();
        this.configure(members).whenComplete((index, error) -> {
            if (error == null) {
                future.complete(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.OK)).withIndex((long)index)).withTerm(this.raft.getCluster().getConfiguration().term())).withTime(this.raft.getCluster().getConfiguration().time())).withMembers(members)).build()));
            } else {
                future.complete(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<LeaveResponse> onLeave(LeaveRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)LeaveResponse.builder().withStatus(RaftResponse.Status.ERROR)).build()));
        }
        if (this.raft.getCluster().getMember(request.member().memberId()) == null) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(RaftResponse.Status.OK)).withMembers(this.raft.getCluster().getMembers())).build()));
        }
        RaftMember member = request.member();
        Collection<RaftMember> members = this.raft.getCluster().getMembers();
        members.remove(member);
        CompletableFuture<LeaveResponse> future = new CompletableFuture<LeaveResponse>();
        this.configure(members).whenComplete((index, error) -> {
            if (error == null) {
                future.complete(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)((LeaveResponse.Builder)((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(RaftResponse.Status.OK)).withIndex((long)index)).withTerm(this.raft.getCluster().getConfiguration().term())).withTime(this.raft.getCluster().getConfiguration().time())).withMembers(members)).build()));
            } else {
                future.complete(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<TransferResponse> onTransfer(TransferRequest request) {
        this.logRequest(request);
        RaftMemberContext member = this.raft.getCluster().getMemberState(request.member());
        if (member == null) {
            return CompletableFuture.completedFuture(this.logResponse(((TransferResponse.Builder)((TransferResponse.Builder)TransferResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE)).build()));
        }
        this.transferring = true;
        CompletableFuture<TransferResponse> future = new CompletableFuture<TransferResponse>();
        this.appender.appendEntries(this.raft.getLogWriter().getLastIndex()).whenComplete((result, error) -> {
            if (this.isRunning()) {
                if (error == null) {
                    this.log.debug("Transferring leadership to {}", (Object)request.member());
                    this.raft.transition(RaftServer.Role.FOLLOWER);
                    future.complete(this.logResponse(((TransferResponse.Builder)TransferResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
                } else if (error instanceof CompletionException && error.getCause() instanceof RaftException) {
                    future.complete(this.logResponse(((TransferResponse.Builder)((TransferResponse.Builder)TransferResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)error.getCause()).getType(), error.getMessage())).build()));
                } else if (error instanceof RaftException) {
                    future.complete(this.logResponse(((TransferResponse.Builder)((TransferResponse.Builder)TransferResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)error).getType(), error.getMessage())).build()));
                } else {
                    future.complete(this.logResponse(((TransferResponse.Builder)((TransferResponse.Builder)TransferResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, error.getMessage())).build()));
                }
            } else {
                future.complete(this.logResponse(((TransferResponse.Builder)((TransferResponse.Builder)TransferResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE)).build()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.logRequest(request);
        RaftMemberContext member = this.raft.getCluster().getMemberState(request.candidate());
        if (member != null) {
            member.resetFailureCount();
        }
        return CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withAccepted(false).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        if (this.updateTermAndLeader(request.term(), null)) {
            this.log.debug("Received greater term");
            this.raft.transition(RaftServer.Role.FOLLOWER);
            return super.onVote(request);
        }
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(false).build()));
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        if (this.updateTermAndLeader(request.term(), request.leader())) {
            CompletableFuture<AppendResponse> future = super.onAppend(request);
            this.raft.transition(RaftServer.Role.FOLLOWER);
            return future;
        }
        if (request.term() < this.raft.getTerm()) {
            this.logRequest(request);
            return CompletableFuture.completedFuture(this.logResponse(((AppendResponse.Builder)AppendResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withSucceeded(false).withLastLogIndex(this.raft.getLogWriter().getLastIndex()).build()));
        }
        this.raft.setLeader(request.leader());
        this.raft.transition(RaftServer.Role.FOLLOWER);
        return super.onAppend(request);
    }

    @Override
    public CompletableFuture<MetadataResponse> onMetadata(MetadataRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.transferring) {
            return CompletableFuture.completedFuture(this.logResponse(((MetadataResponse.Builder)((MetadataResponse.Builder)MetadataResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE)).build()));
        }
        CompletableFuture<MetadataResponse> future = new CompletableFuture<MetadataResponse>();
        Indexed entry = new Indexed(this.raft.getLastApplied(), (Object)new MetadataEntry(this.raft.getTerm(), System.currentTimeMillis(), request.session()), 0);
        this.raft.getServiceManager().apply((Indexed<? extends RaftLogEntry>)entry).whenComplete((result, error) -> {
            if (error == null) {
                future.complete(this.logResponse(((MetadataResponse.Builder)MetadataResponse.builder().withStatus(RaftResponse.Status.OK)).withSessions(result.sessions()).build()));
            } else {
                future.complete(this.logResponse(((MetadataResponse.Builder)((MetadataResponse.Builder)MetadataResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<CommandResponse> onCommand(CommandRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.transferring) {
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE)).build()));
        }
        RaftSession session = this.raft.getSessions().getSession(request.session());
        if (session == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNKNOWN_SESSION)).build()));
        }
        long sequenceNumber = request.sequenceNumber();
        PendingCommand existingCommand = session.getCommand(sequenceNumber);
        if (existingCommand != null) {
            if (sequenceNumber <= session.nextRequestSequence()) {
                this.drainCommands(sequenceNumber, session);
            }
            this.log.trace("Returning pending result for command sequence {}", (Object)sequenceNumber);
            return existingCommand.future();
        }
        CompletableFuture<CommandResponse> future = new CompletableFuture<CommandResponse>();
        if (sequenceNumber > session.nextRequestSequence()) {
            if (session.getCommands().size() < 1000) {
                this.log.trace("Registered sequence command {} > {}", (Object)sequenceNumber, (Object)session.nextRequestSequence());
                session.registerCommand(request.sequenceNumber(), new PendingCommand(request, future));
                return future;
            }
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.COMMAND_FAILURE)).withLastSequence(session.getRequestSequence())).build()));
        }
        if (sequenceNumber <= session.getCommandSequence()) {
            OperationResult result = session.getResult(sequenceNumber);
            if (result != null) {
                this.completeOperation(result, CommandResponse.builder(), null, future);
            } else {
                future.complete(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build());
            }
        } else {
            this.commitCommand(request, future);
            session.setRequestSequence(sequenceNumber);
            this.drainCommands(sequenceNumber, session);
        }
        return future.thenApply(this::logResponse);
    }

    private void drainCommands(long sequenceNumber, RaftSession session) {
        long nextSequence = session.nextRequestSequence();
        for (long i = sequenceNumber; i < nextSequence; ++i) {
            PendingCommand nextCommand = session.removeCommand(i);
            if (nextCommand == null) continue;
            this.commitCommand(nextCommand.request(), nextCommand.future());
        }
        PendingCommand nextCommand = session.removeCommand(nextSequence);
        while (nextCommand != null) {
            this.commitCommand(nextCommand.request(), nextCommand.future());
            session.setRequestSequence(nextSequence);
            nextSequence = session.nextRequestSequence();
            nextCommand = session.removeCommand(nextSequence);
        }
    }

    private void commitCommand(CommandRequest request, CompletableFuture<CommandResponse> future) {
        long term = this.raft.getTerm();
        long timestamp = System.currentTimeMillis();
        CommandEntry command = new CommandEntry(term, timestamp, request.session(), request.sequenceNumber(), request.operation());
        this.appendAndCompact(command).whenCompleteAsync((entry, error) -> {
            if (error != null) {
                Throwable cause = Throwables.getRootCause((Throwable)error);
                if (Throwables.getRootCause((Throwable)error) instanceof StorageException.TooLarge) {
                    this.log.warn("Failed to append command {}", (Object)command, (Object)cause);
                    future.complete(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build());
                } else {
                    future.complete(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.COMMAND_FAILURE)).build());
                }
                return;
            }
            this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
                this.raft.checkThread();
                if (this.isRunning()) {
                    if (commitError == null) {
                        this.raft.getServiceManager().apply(entry.index()).whenComplete((r, e) -> this.completeOperation((OperationResult)r, CommandResponse.builder(), (Throwable)e, future));
                    } else {
                        future.complete(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.COMMAND_FAILURE)).build());
                    }
                } else {
                    future.complete(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.COMMAND_FAILURE)).build());
                }
            });
        }, (Executor)this.raft.getThreadContext());
    }

    @Override
    public CompletableFuture<QueryResponse> onQuery(QueryRequest request) {
        CompletableFuture future;
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLastApplied() < request.session()) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNKNOWN_SESSION, "Session has not yet been created. You're seeing into the future!")).build()));
        }
        RaftSession session = this.raft.getSessions().getSession(request.session());
        if (session == null) {
            this.log.warn("Unknown session {}", (Object)request.session());
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNKNOWN_SESSION)).build()));
        }
        Indexed entry = new Indexed(request.index(), (Object)new QueryEntry(this.raft.getTerm(), System.currentTimeMillis(), request.session(), request.sequenceNumber(), request.operation()), 0);
        switch (session.readConsistency()) {
            case SEQUENTIAL: {
                future = this.queryLocal((Indexed<QueryEntry>)entry);
                break;
            }
            case LINEARIZABLE_LEASE: {
                future = this.queryBoundedLinearizable((Indexed<QueryEntry>)entry);
                break;
            }
            case LINEARIZABLE: {
                future = this.queryLinearizable((Indexed<QueryEntry>)entry);
                break;
            }
            default: {
                future = Futures.exceptionalFuture((Throwable)new IllegalStateException("Unknown consistency level: " + (Object)((Object)session.readConsistency())));
            }
        }
        return future.thenApply(this::logResponse);
    }

    private CompletableFuture<QueryResponse> queryBoundedLinearizable(Indexed<QueryEntry> entry) {
        return this.applyQuery(entry);
    }

    private CompletableFuture<QueryResponse> queryLinearizable(Indexed<QueryEntry> entry) {
        return this.applyQuery(entry).thenComposeAsync(response -> ((CompletableFuture)this.appender.appendEntries().thenApply(index -> response)).exceptionally(error -> ((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.QUERY_FAILURE, error.getMessage())).build()), (Executor)this.raft.getThreadContext());
    }

    @Override
    public CompletableFuture<OpenSessionResponse> onOpenSession(OpenSessionRequest request) {
        long term = this.raft.getTerm();
        long timestamp = System.currentTimeMillis();
        long minTimeout = request.minTimeout();
        long maxTimeout = request.maxTimeout() != 0L ? request.maxTimeout() : this.raft.getSessionTimeout().toMillis();
        this.raft.checkThread();
        this.logRequest(request);
        CompletableFuture<OpenSessionResponse> future = new CompletableFuture<OpenSessionResponse>();
        this.appendAndCompact(new OpenSessionEntry(term, timestamp, request.node(), request.serviceName(), request.serviceType(), request.serviceConfig(), request.readConsistency(), minTimeout, maxTimeout)).whenCompleteAsync((entry, error) -> {
            if (error != null) {
                future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                return;
            }
            this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
                this.raft.checkThread();
                if (this.isRunning()) {
                    if (commitError == null) {
                        this.raft.getServiceManager().apply(entry.index()).whenComplete((sessionId, sessionError) -> {
                            if (sessionError == null) {
                                future.complete(this.logResponse(((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.OK)).withSession((long)sessionId).withTimeout(maxTimeout).build()));
                            } else if (sessionError instanceof CompletionException && sessionError.getCause() instanceof RaftException) {
                                future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)sessionError.getCause()).getType(), sessionError.getMessage())).build()));
                            } else if (sessionError instanceof RaftException) {
                                future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)sessionError).getType(), sessionError.getMessage())).build()));
                            } else {
                                future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, sessionError.getMessage())).build()));
                            }
                        });
                    } else {
                        future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                    }
                } else {
                    future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE)).build()));
                }
            });
        }, (Executor)this.raft.getThreadContext());
        return future;
    }

    @Override
    public CompletableFuture<KeepAliveResponse> onKeepAlive(KeepAliveRequest request) {
        long term = this.raft.getTerm();
        long timestamp = System.currentTimeMillis();
        this.raft.checkThread();
        this.logRequest(request);
        CompletableFuture<KeepAliveResponse> future = new CompletableFuture<KeepAliveResponse>();
        this.appendAndCompact(new KeepAliveEntry(term, timestamp, request.sessionIds(), request.commandSequenceNumbers(), request.eventIndexes())).whenCompleteAsync((entry, error) -> {
            if (error != null) {
                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.raft.getCluster().getMember().memberId()).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                return;
            }
            this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
                this.raft.checkThread();
                if (this.isRunning()) {
                    if (commitError == null) {
                        this.raft.getServiceManager().apply(entry.index()).whenCompleteAsync((sessionResult, sessionError) -> {
                            if (sessionError == null) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.OK)).withLeader(this.raft.getCluster().getMember().memberId()).withMembers(this.raft.getCluster().getMembers().stream().map(RaftMember::memberId).filter(m -> m != null).collect(Collectors.toList())).withSessionIds((long[])sessionResult).build()));
                            } else if (sessionError instanceof CompletionException && sessionError.getCause() instanceof RaftException) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.raft.getCluster().getMember().memberId()).withError(((RaftException)sessionError.getCause()).getType(), sessionError.getMessage())).build()));
                            } else if (sessionError instanceof RaftException) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.raft.getCluster().getMember().memberId()).withError(((RaftException)sessionError).getType(), sessionError.getMessage())).build()));
                            } else {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.raft.getCluster().getMember().memberId()).withError(RaftError.Type.PROTOCOL_ERROR, sessionError.getMessage())).build()));
                            }
                        }, (Executor)this.raft.getThreadContext());
                    } else {
                        future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.raft.getCluster().getMember().memberId()).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                    }
                } else {
                    DefaultRaftMember leader = this.raft.getLeader();
                    future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withLeader(leader != null ? leader.memberId() : null).withError(RaftError.Type.ILLEGAL_MEMBER_STATE)).build()));
                }
            });
        }, (Executor)this.raft.getThreadContext());
        return future;
    }

    @Override
    public CompletableFuture<CloseSessionResponse> onCloseSession(CloseSessionRequest request) {
        long term = this.raft.getTerm();
        long timestamp = System.currentTimeMillis();
        this.raft.checkThread();
        this.logRequest(request);
        CompletableFuture<CloseSessionResponse> future = new CompletableFuture<CloseSessionResponse>();
        this.appendAndCompact(new CloseSessionEntry(term, timestamp, request.session(), false, request.delete())).whenCompleteAsync((entry, error) -> {
            if (error != null) {
                future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                return;
            }
            this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
                this.raft.checkThread();
                if (this.isRunning()) {
                    if (commitError == null) {
                        this.raft.getServiceManager().apply(entry.index()).whenComplete((closeResult, closeError) -> {
                            if (closeError == null) {
                                future.complete(this.logResponse(((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
                            } else if (closeError instanceof CompletionException && closeError.getCause() instanceof RaftException) {
                                future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)closeError.getCause()).getType(), closeError.getMessage())).build()));
                            } else if (closeError instanceof RaftException) {
                                future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)closeError).getType(), closeError.getMessage())).build()));
                            } else {
                                future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, closeError.getMessage())).build()));
                            }
                        });
                    } else {
                        future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                    }
                } else {
                    future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE)).build()));
                }
            });
        }, (Executor)this.raft.getThreadContext());
        return future;
    }

    private <E extends RaftLogEntry> CompletableFuture<Indexed<E>> appendAndCompact(E entry) {
        return this.appendAndCompact(entry, 0);
    }

    protected <E extends RaftLogEntry> CompletableFuture<Indexed<E>> appendAndCompact(E entry, int attempt) {
        if (attempt == 5) {
            return Futures.exceptionalFuture((Throwable)new StorageException.OutOfDiskSpace("Not enough space to append entry"));
        }
        try {
            return CompletableFuture.completedFuture(this.raft.getLogWriter().append(entry)).thenApply(indexed -> {
                this.log.trace("Appended {}", indexed);
                return indexed;
            });
        }
        catch (StorageException.TooLarge e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
        catch (StorageException.OutOfDiskSpace e) {
            this.log.warn("Caught OutOfDiskSpace error! Force compacting logs...");
            return this.raft.getServiceManager().compact().thenCompose(v -> this.appendAndCompact(entry, attempt + 1));
        }
    }

    private void cancelAppendTimer() {
        if (this.appendTimer != null) {
            this.log.trace("Cancelling append timer");
            this.appendTimer.cancel();
        }
    }

    private void stepDown() {
        if (this.raft.getLeader() != null && this.raft.getLeader().equals(this.raft.getCluster().getMember())) {
            this.raft.setLeader(null);
        }
    }

    private void failPendingCommands() {
        for (RaftSession session : this.raft.getSessions().getSessions()) {
            for (PendingCommand command : session.clearCommands()) {
                command.future().complete(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.COMMAND_FAILURE, "Request sequence number " + command.request().sequenceNumber() + " out of sequence")).withLastSequence(session.getRequestSequence())).build()));
            }
        }
    }

    @Override
    public synchronized CompletableFuture<Void> stop() {
        this.raft.getMembershipService().removeListener((EventListener)this.clusterListener);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)super.stop().thenRun(this.appender::close)).thenRun(this::cancelAppendTimer)).thenRun(this::stepDown)).thenRun(this::failPendingCommands);
    }
}

