/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.protocols.raft.partition.RaftPartitionGroupConfig;
import io.atomix.protocols.raft.partition.impl.RaftClientCommunicator;
import io.atomix.protocols.raft.partition.impl.RaftNamespaces;
import io.atomix.protocols.raft.partition.impl.RaftPartitionClient;
import io.atomix.protocols.raft.partition.impl.RaftPartitionServer;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class RaftPartition
implements Partition {
    private final PartitionId partitionId;
    private final RaftPartitionGroupConfig config;
    private final File dataDirectory;
    private final ThreadContextFactory threadContextFactory;
    private PartitionMetadata partition;
    private RaftPartitionClient client;
    private RaftPartitionServer server;

    public RaftPartition(PartitionId partitionId, RaftPartitionGroupConfig config, File dataDirectory, ThreadContextFactory threadContextFactory) {
        this.partitionId = partitionId;
        this.config = config;
        this.dataDirectory = dataDirectory;
        this.threadContextFactory = threadContextFactory;
    }

    public PartitionId id() {
        return this.partitionId;
    }

    public String name() {
        return String.format("%s-partition-%d", this.partitionId.group(), this.partitionId.id());
    }

    public long term() {
        return this.client != null ? this.client.term() : 0L;
    }

    public MemberId primary() {
        return this.client != null ? this.client.leader() : null;
    }

    public Collection<MemberId> backups() {
        MemberId leader = this.primary();
        if (leader == null) {
            return this.members();
        }
        return this.members().stream().filter(m -> !m.equals((Object)leader)).collect(Collectors.toSet());
    }

    public Collection<MemberId> members() {
        return this.partition != null ? this.partition.members() : Collections.emptyList();
    }

    public File dataDirectory() {
        return this.dataDirectory;
    }

    public CompletableFuture<Void> snapshot() {
        RaftPartitionServer server = this.server;
        if (server != null) {
            return server.snapshot();
        }
        return CompletableFuture.completedFuture(null);
    }

    public RaftPartitionClient getClient() {
        return this.client;
    }

    CompletableFuture<Partition> open(PartitionMetadata metadata, PartitionManagementService managementService) {
        this.partition = metadata;
        this.client = this.createClient(managementService);
        if (this.partition.members().contains(managementService.getMembershipService().getLocalMember().id())) {
            this.server = this.createServer(managementService);
            return ((CompletableFuture)this.server.start().thenCompose(v -> this.client.start())).thenApply(v -> null);
        }
        return this.client.start().thenApply(v -> this);
    }

    CompletableFuture<Void> update(PartitionMetadata metadata, PartitionManagementService managementService) {
        if (this.server == null && metadata.members().contains(managementService.getMembershipService().getLocalMember().id())) {
            this.server = this.createServer(managementService);
            return this.server.join(metadata.members());
        }
        if (this.server != null && !metadata.members().contains(managementService.getMembershipService().getLocalMember().id())) {
            return this.server.leave().thenRun(() -> {
                this.server = null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    CompletableFuture<Void> close() {
        return ((CompletableFuture)((CompletableFuture)this.closeClient().exceptionally(v -> null)).thenCompose(v -> this.closeServer())).exceptionally(v -> null);
    }

    private CompletableFuture<Void> closeClient() {
        if (this.client != null) {
            return this.client.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> closeServer() {
        if (this.server != null) {
            return this.server.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    protected RaftPartitionServer createServer(PartitionManagementService managementService) {
        return new RaftPartitionServer(this, this.config, managementService.getMembershipService().getLocalMember().id(), managementService.getMembershipService(), managementService.getMessagingService(), managementService.getPrimitiveTypes(), this.threadContextFactory);
    }

    private RaftPartitionClient createClient(PartitionManagementService managementService) {
        return new RaftPartitionClient(this, managementService.getMembershipService().getLocalMember().id(), new RaftClientCommunicator(this.name(), Serializer.using((Namespace)RaftNamespaces.RAFT_PROTOCOL), managementService.getMessagingService()), this.threadContextFactory);
    }

    public CompletableFuture<Void> delete() {
        return ((CompletableFuture)this.server.stop().thenCompose(v -> this.client.stop())).thenRun(() -> {
            if (this.server != null) {
                this.server.delete();
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", (Object)this.id()).toString();
    }
}

