/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition;

import com.google.common.base.Preconditions;
import io.atomix.storage.StorageLevel;
import io.atomix.utils.memory.MemorySize;

public class RaftStorageConfig {
    private static final String DATA_PREFIX = ".data";
    private static final StorageLevel DEFAULT_STORAGE_LEVEL = StorageLevel.DISK;
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
    private static final int DEFAULT_MAX_ENTRY_SIZE = 0x100000;
    private static final boolean DEFAULT_FLUSH_ON_COMMIT = false;
    private String directory;
    private StorageLevel level = DEFAULT_STORAGE_LEVEL;
    private int maxEntrySize = 0x100000;
    private long segmentSize = 0x2000000L;
    private boolean flushOnCommit = false;

    public StorageLevel getLevel() {
        return this.level;
    }

    public RaftStorageConfig setLevel(StorageLevel storageLevel) {
        this.level = (StorageLevel)Preconditions.checkNotNull((Object)storageLevel);
        return this;
    }

    public MemorySize getSegmentSize() {
        return MemorySize.from((long)this.segmentSize);
    }

    public RaftStorageConfig setSegmentSize(MemorySize segmentSize) {
        this.segmentSize = segmentSize.bytes();
        return this;
    }

    public MemorySize getMaxEntrySize() {
        return MemorySize.from((long)this.maxEntrySize);
    }

    public RaftStorageConfig setMaxEntrySize(MemorySize maxEntrySize) {
        this.maxEntrySize = (int)maxEntrySize.bytes();
        return this;
    }

    public boolean isFlushOnCommit() {
        return this.flushOnCommit;
    }

    public RaftStorageConfig setFlushOnCommit(boolean flushOnCommit) {
        this.flushOnCommit = flushOnCommit;
        return this;
    }

    public String getDirectory(String groupName) {
        return this.directory != null ? this.directory : System.getProperty("atomix.data", DATA_PREFIX) + "/" + groupName;
    }

    public RaftStorageConfig setDirectory(String directory) {
        this.directory = directory;
        return this;
    }
}

