/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session;

import com.google.common.base.Preconditions;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.session.SessionClient;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public interface RaftSessionClient
extends SessionClient {

    public static abstract class Builder
    extends SessionClient.Builder {
        protected Duration minTimeout = Duration.ofMillis(250L);
        protected Duration maxTimeout = Duration.ofSeconds(30L);
        protected ReadConsistency readConsistency = ReadConsistency.SEQUENTIAL;
        protected CommunicationStrategy communicationStrategy = CommunicationStrategy.LEADER;
        protected Recovery recoveryStrategy = Recovery.RECOVER;
        protected int maxRetries = 0;
        protected Duration retryDelay = Duration.ofMillis(100L);

        public Builder withMinTimeout(Duration minTimeout) {
            this.minTimeout = (Duration)Preconditions.checkNotNull((Object)minTimeout, (Object)"minTimeout cannot be null");
            return this;
        }

        public Builder withMaxTimeout(Duration maxTimeout) {
            this.maxTimeout = (Duration)Preconditions.checkNotNull((Object)maxTimeout, (Object)"maxTimeout cannot be null");
            return this;
        }

        public Builder withReadConsistency(ReadConsistency readConsistency) {
            this.readConsistency = (ReadConsistency)((Object)Preconditions.checkNotNull((Object)((Object)readConsistency), (Object)"readConsistency cannot be null"));
            return this;
        }

        public Builder withCommunicationStrategy(CommunicationStrategy communicationStrategy) {
            this.communicationStrategy = (CommunicationStrategy)((Object)Preconditions.checkNotNull((Object)((Object)communicationStrategy), (Object)"communicationStrategy cannot be null"));
            return this;
        }

        public Builder withRecoveryStrategy(Recovery recoveryStrategy) {
            this.recoveryStrategy = (Recovery)Preconditions.checkNotNull((Object)recoveryStrategy, (Object)"recoveryStrategy cannot be null");
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must be positive");
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withRetryDelayMillis(long retryDelayMillis) {
            return this.withRetryDelay(Duration.ofMillis(retryDelayMillis));
        }

        public Builder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
            return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
        }

        public Builder withRetryDelay(Duration retryDelay) {
            this.retryDelay = (Duration)Preconditions.checkNotNull((Object)retryDelay, (Object)"retryDelay cannot be null");
            return this;
        }
    }
}

