/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.system;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.utils.misc.TimestampPrinter;
import java.util.Collection;

public class Configuration {
    private final long index;
    private final long term;
    private final long time;
    private final Collection<RaftMember> members;

    public Configuration(long index, long term, long time, Collection<RaftMember> members) {
        Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (Object)"time must be positive");
        Preconditions.checkNotNull(members, (Object)"members cannot be null");
        this.index = index;
        this.term = term;
        this.time = time;
        this.members = members;
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    public long time() {
        return this.time;
    }

    public Collection<RaftMember> members() {
        return this.members;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("time", (Object)new TimestampPrinter(this.time)).add("members", this.members).toString();
    }
}

