/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.protocol.RaftResponse;
import java.util.Objects;

public abstract class AbstractRaftResponse
implements RaftResponse {
    protected final RaftResponse.Status status;
    protected final RaftError error;

    protected AbstractRaftResponse(RaftResponse.Status status, RaftError error) {
        this.status = status;
        this.error = error;
    }

    @Override
    public RaftResponse.Status status() {
        return this.status;
    }

    @Override
    public RaftError error() {
        return this.error;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        AbstractRaftResponse response = (AbstractRaftResponse)object;
        return response.status == this.status && Objects.equals(response.error, this.error);
    }

    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    protected static abstract class Builder<T extends Builder<T, U>, U extends AbstractRaftResponse>
    implements RaftResponse.Builder<T, U> {
        protected RaftResponse.Status status;
        protected RaftError error;

        protected Builder() {
        }

        @Override
        public T withStatus(RaftResponse.Status status) {
            this.status = (RaftResponse.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status cannot be null"));
            return (T)this;
        }

        @Override
        public T withError(RaftError error) {
            this.error = (RaftError)Preconditions.checkNotNull((Object)error, (Object)"error cannot be null");
            return (T)this;
        }

        protected void validate() {
            Preconditions.checkNotNull((Object)((Object)this.status), (Object)"status cannot be null");
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
        }
    }
}

