/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atomix.cluster.MemberId;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import io.atomix.protocols.raft.session.impl.MemberSelectorManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;

public final class MemberSelector
implements Iterator<MemberId>,
AutoCloseable {
    private final MemberSelectorManager selectors;
    private MemberId leader;
    private Set<MemberId> members;
    private volatile MemberId selection;
    private final CommunicationStrategy strategy;
    private Collection<MemberId> selections = new LinkedList<MemberId>();
    private Iterator<MemberId> selectionsIterator;

    public MemberSelector(MemberId leader, Collection<MemberId> members, CommunicationStrategy strategy, MemberSelectorManager selectors) {
        this.leader = leader;
        this.members = new LinkedHashSet<MemberId>(members);
        this.strategy = (CommunicationStrategy)((Object)Preconditions.checkNotNull((Object)((Object)strategy), (Object)"strategy cannot be null"));
        this.selectors = (MemberSelectorManager)Preconditions.checkNotNull((Object)selectors, (Object)"selectors cannot be null");
        this.selections = strategy.selectConnections(leader, Lists.newLinkedList(members));
    }

    public State state() {
        if (this.selectionsIterator == null) {
            return State.RESET;
        }
        if (this.hasNext()) {
            return State.ITERATE;
        }
        return State.COMPLETE;
    }

    public MemberId current() {
        return this.selection;
    }

    public MemberId leader() {
        return this.leader;
    }

    public Set<MemberId> members() {
        return this.members;
    }

    public MemberSelector reset() {
        if (this.selectionsIterator != null) {
            this.selections = this.strategy.selectConnections(this.leader, Lists.newLinkedList(this.members));
            this.selectionsIterator = null;
        }
        return this;
    }

    public MemberSelector reset(MemberId leader, Collection<MemberId> members) {
        if (this.changed(leader, members)) {
            this.leader = leader != null && members.contains(leader) ? leader : null;
            this.members = Sets.newLinkedHashSet(members);
            this.selections = this.strategy.selectConnections(leader, Lists.newLinkedList(members));
            this.selectionsIterator = null;
        }
        return this;
    }

    private boolean changed(MemberId leader, Collection<MemberId> members) {
        Preconditions.checkNotNull(members, (Object)"members");
        Preconditions.checkArgument((!members.isEmpty() ? 1 : 0) != 0, (Object)"members cannot be empty");
        if (leader != null && !members.contains(leader)) {
            leader = null;
        }
        if (!Objects.equals(this.leader, leader)) {
            return true;
        }
        return !this.matches(this.members, members);
    }

    private boolean matches(Collection<MemberId> left, Collection<MemberId> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (MemberId address : left) {
            if (right.contains(address)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.selectionsIterator == null ? !this.selections.isEmpty() : this.selectionsIterator.hasNext();
    }

    @Override
    public MemberId next() {
        MemberId selection;
        if (this.selectionsIterator == null) {
            this.selectionsIterator = this.selections.iterator();
        }
        this.selection = selection = this.selectionsIterator.next();
        return selection;
    }

    @Override
    public void close() {
        this.selectors.remove(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("strategy", (Object)this.strategy).toString();
    }

    public static enum State {
        RESET,
        ITERATE,
        COMPLETE;

    }
}

