/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service;

import com.google.common.collect.Sets;
import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionListener;
import io.atomix.primitive.session.Sessions;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessionRegistry;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

class RaftSessions
implements Sessions {
    private final PrimitiveId primitiveId;
    private final Set<SessionListener> listeners = Sets.newIdentityHashSet();
    private final RaftSessionRegistry sessionManager;

    public RaftSessions(PrimitiveId primitiveId, RaftSessionRegistry sessionManager) {
        this.primitiveId = primitiveId;
        this.sessionManager = sessionManager;
    }

    RaftSession addSession(RaftSession session) {
        return this.sessionManager.addSession(session);
    }

    void openSession(RaftSession session) {
        RaftSession singletonSession = this.sessionManager.addSession(session);
        singletonSession.open();
        this.listeners.forEach(l -> l.onOpen((Session)singletonSession));
    }

    void expireSession(RaftSession session) {
        RaftSession singletonSession = this.sessionManager.removeSession(session.sessionId());
        if (singletonSession != null) {
            singletonSession.expire();
            this.listeners.forEach(l -> l.onExpire((Session)singletonSession));
        }
    }

    void closeSession(RaftSession session) {
        RaftSession singletonSession = this.sessionManager.removeSession(session.sessionId());
        if (singletonSession != null) {
            singletonSession.close();
            this.listeners.forEach(l -> l.onClose((Session)singletonSession));
        }
    }

    Collection<RaftSession> getSessions() {
        return this.sessionManager.getSessions(this.primitiveId);
    }

    public Session getSession(long sessionId) {
        RaftSession session = this.sessionManager.getSession(sessionId);
        return session != null && session.getState().active() ? session : null;
    }

    public Sessions addListener(SessionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public Sessions removeListener(SessionListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public Iterator<Session> iterator() {
        return this.getSessions().iterator();
    }
}

