/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy;

import io.atomix.cluster.NodeId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum CommunicationStrategy {
    ANY{

        @Override
        public List<NodeId> selectConnections(NodeId leader, List<NodeId> members) {
            Collections.shuffle(members);
            return members;
        }
    }
    ,
    LEADER{

        @Override
        public List<NodeId> selectConnections(NodeId leader, List<NodeId> members) {
            if (leader != null) {
                return Collections.singletonList(leader);
            }
            Collections.shuffle(members);
            return members;
        }
    }
    ,
    FOLLOWERS{

        @Override
        public List<NodeId> selectConnections(NodeId leader, List<NodeId> members) {
            Collections.shuffle(members);
            if (leader != null && members.size() > 1) {
                ArrayList<NodeId> results = new ArrayList<NodeId>(members.size());
                for (NodeId memberId : members) {
                    if (memberId.equals((Object)leader)) continue;
                    results.add(memberId);
                }
                return results;
            }
            return members;
        }
    };


    public abstract List<NodeId> selectConnections(NodeId var1, List<NodeId> var2);
}

