/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.RaftRequest;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.PassiveRole;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.storage.journal.Indexed;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public abstract class ActiveRole
extends PassiveRole {
    protected ActiveRole(RaftContext context) {
        super(context);
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        boolean transition = this.updateTermAndLeader(request.term(), request.leader());
        CompletableFuture<AppendResponse> future = this.handleAppend(request);
        if (transition) {
            this.raft.transition(RaftServer.Role.FOLLOWER);
        }
        return future;
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), null);
        return CompletableFuture.completedFuture(this.logResponse(this.handlePoll(request)));
    }

    protected PollResponse handlePoll(PollRequest request) {
        if (request.term() < this.raft.getTerm()) {
            this.log.debug("Rejected {}: candidate's term is less than the current term", (Object)request);
            return ((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withAccepted(false).build();
        }
        if (this.isLogUpToDate(request.lastLogIndex(), request.lastLogTerm(), request)) {
            return ((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withAccepted(true).build();
        }
        return ((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withAccepted(false).build();
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        boolean transition = this.updateTermAndLeader(request.term(), null);
        CompletableFuture<VoteResponse> future = CompletableFuture.completedFuture(this.logResponse(this.handleVote(request)));
        if (transition) {
            this.raft.transition(RaftServer.Role.FOLLOWER);
        }
        return future;
    }

    protected VoteResponse handleVote(VoteRequest request) {
        if (request.term() < this.raft.getTerm()) {
            this.log.debug("Rejected {}: candidate's term is less than the current term", (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(false).build();
        }
        if (this.raft.getLeader() != null) {
            this.log.debug("Rejected {}: leader already exists", (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(false).build();
        }
        if (!this.raft.getCluster().getRemoteMemberStates().stream().map(m -> m.getMember().nodeId()).collect(Collectors.toSet()).contains(request.candidate())) {
            this.log.debug("Rejected {}: candidate is not known to the local member", (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(false).build();
        }
        if (this.raft.getLastVotedFor() == null) {
            if (this.isLogUpToDate(request.lastLogIndex(), request.lastLogTerm(), request)) {
                this.raft.setLastVotedFor(request.candidate());
                return ((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(true).build();
            }
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(false).build();
        }
        if (this.raft.getLastVotedFor() == request.candidate()) {
            this.log.debug("Accepted {}: already voted for {}", (Object)request, (Object)this.raft.getCluster().getMember(this.raft.getLastVotedFor()).nodeId());
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(true).build();
        }
        this.log.debug("Rejected {}: already voted for {}", (Object)request, (Object)this.raft.getCluster().getMember(this.raft.getLastVotedFor()).nodeId());
        return ((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(false).build();
    }

    boolean isLogUpToDate(long lastIndex, long lastTerm, RaftRequest request) {
        Indexed lastEntry = this.raft.getLogWriter().getLastEntry();
        if (lastEntry == null) {
            this.log.debug("Accepted {}: candidate's log is up-to-date", (Object)request);
            return true;
        }
        if (lastTerm < ((RaftLogEntry)lastEntry.entry()).term()) {
            this.log.debug("Rejected {}: candidate's last log entry ({}) is at a lower term than the local log ({})", new Object[]{request, lastTerm, ((RaftLogEntry)lastEntry.entry()).term()});
            return false;
        }
        if (lastTerm == ((RaftLogEntry)lastEntry.entry()).term() && lastIndex < lastEntry.index()) {
            this.log.debug("Rejected {}: candidate's last log entry ({}) is at a lower index than the local log ({})", new Object[]{request, lastIndex, lastEntry.index()});
            return false;
        }
        this.log.debug("Accepted {}: candidate's log is up-to-date", (Object)request);
        return true;
    }
}

