/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveClient;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.protocols.raft.RaftProtocol;
import io.atomix.protocols.raft.partition.impl.RaftClientCommunicator;
import io.atomix.protocols.raft.partition.impl.RaftNamespaces;
import io.atomix.protocols.raft.partition.impl.RaftPartitionClient;
import io.atomix.protocols.raft.partition.impl.RaftPartitionServer;
import io.atomix.storage.StorageLevel;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class RaftPartition
implements Partition<RaftProtocol> {
    private final PartitionId partitionId;
    private final StorageLevel storageLevel;
    private final File dataDirectory;
    private PartitionMetadata partition;
    private RaftPartitionClient client;
    private RaftPartitionServer server;

    public RaftPartition(PartitionId partitionId, StorageLevel storageLevel, File dataDirectory) {
        this.partitionId = partitionId;
        this.storageLevel = storageLevel;
        this.dataDirectory = dataDirectory;
    }

    public PartitionId id() {
        return this.partitionId;
    }

    public String name() {
        return String.format("%s-partition-%d", this.partitionId.group(), this.partitionId.id());
    }

    public long term() {
        return this.client != null ? this.client.term() : 0L;
    }

    public NodeId primary() {
        return this.client != null ? this.client.leader() : null;
    }

    public Collection<NodeId> backups() {
        NodeId leader = this.primary();
        if (leader == null) {
            return this.members();
        }
        return this.members().stream().filter(m -> !m.equals((Object)leader)).collect(Collectors.toSet());
    }

    public Collection<NodeId> members() {
        return this.partition != null ? this.partition.members() : Collections.emptyList();
    }

    public StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public File dataDirectory() {
        return this.dataDirectory;
    }

    public PrimitiveClient<RaftProtocol> getPrimitiveClient() {
        return this.client;
    }

    CompletableFuture<Partition> open(PartitionMetadata metadata, PartitionManagementService managementService) {
        this.partition = metadata;
        this.client = this.createClient(managementService);
        if (this.partition.members().contains(managementService.getClusterService().getLocalNode().id())) {
            this.server = this.createServer(managementService);
            return ((CompletableFuture)this.server.start().thenCompose(v -> this.client.start())).thenApply(v -> null);
        }
        return this.client.start().thenApply(v -> this);
    }

    CompletableFuture<Void> update(PartitionMetadata metadata, PartitionManagementService managementService) {
        if (this.server == null && metadata.members().contains(managementService.getClusterService().getLocalNode().id())) {
            this.server = this.createServer(managementService);
            return this.server.join(metadata.members());
        }
        if (this.server != null && !metadata.members().contains(managementService.getClusterService().getLocalNode().id())) {
            return this.server.leave().thenRun(() -> {
                this.server = null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    CompletableFuture<Void> close() {
        return this.closeClient().thenCompose(v -> this.closeServer());
    }

    private CompletableFuture<Void> closeClient() {
        if (this.client != null) {
            return this.client.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> closeServer() {
        if (this.server != null) {
            return this.server.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    protected RaftPartitionServer createServer(PartitionManagementService managementService) {
        return new RaftPartitionServer(this, managementService.getClusterService().getLocalNode().id(), managementService.getClusterService(), managementService.getCommunicationService(), managementService.getPrimitiveTypes());
    }

    private RaftPartitionClient createClient(PartitionManagementService managementService) {
        return new RaftPartitionClient(this, managementService.getClusterService().getLocalNode().id(), new RaftClientCommunicator(this.name(), Serializer.using((Namespace)RaftNamespaces.RAFT_PROTOCOL), managementService.getCommunicationService()));
    }

    public CompletableFuture<Void> delete() {
        return ((CompletableFuture)this.server.stop().thenCompose(v -> this.client.stop())).thenRun(() -> {
            if (this.server != null) {
                this.server.delete();
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", (Object)this.id()).toString();
    }
}

